/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.regexdiagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.regexdiagram.ReToken;
import net.sourceforge.plantuml.regexdiagram.ReTokenType;
import net.sourceforge.plantuml.regexdiagram.RegexParsingException;
import net.sourceforge.plantuml.utils.CharInspector;

public class RegexExpression {
    public static List<ReToken> parse(CharInspector it) throws RegexParsingException {
        char current;
        ArrayList<ReToken> result = new ArrayList<ReToken>();
        while ((current = it.peek(0)) != '\u0000') {
            String s;
            if (RegexExpression.isStartAnchor(it)) {
                s = RegexExpression.readAnchor(it);
                result.add(new ReToken(ReTokenType.ANCHOR, s));
                continue;
            }
            if (RegexExpression.isEscapedChar(it)) {
                result.add(new ReToken(ReTokenType.ESCAPED_CHAR, "" + it.peek(1)));
                it.jump();
                it.jump();
                continue;
            }
            if (current == '|') {
                result.add(new ReToken(ReTokenType.ALTERNATIVE, "|"));
                it.jump();
                continue;
            }
            if (current == '[') {
                s = RegexExpression.readGroup(it);
                result.add(new ReToken(ReTokenType.GROUP, s));
                continue;
            }
            if (RegexExpression.isStartOpenParenthesis(it)) {
                s = RegexExpression.readOpenParenthesis(it);
                result.add(new ReToken(ReTokenType.PARENTHESIS_OPEN, s));
                continue;
            }
            if (current == ')') {
                result.add(new ReToken(ReTokenType.PARENTHESIS_CLOSE, ")"));
                it.jump();
                continue;
            }
            if (RegexExpression.isStartQuantifier(it)) {
                s = RegexExpression.readQuantifier(it);
                result.add(new ReToken(ReTokenType.QUANTIFIER, s));
                continue;
            }
            if (RegexExpression.isStartOctalEscape(it)) {
                s = RegexExpression.readUnicodeOrOctalEscape(it, 4);
                result.add(new ReToken(ReTokenType.CLASS, s));
                continue;
            }
            if (RegexExpression.isStartUnicodeEscape(it)) {
                s = RegexExpression.readUnicodeOrOctalEscape(it, 5);
                result.add(new ReToken(ReTokenType.CLASS, s));
                continue;
            }
            if (RegexExpression.isStartUnicodeClass(it)) {
                s = RegexExpression.readUnicodeClass(it);
                result.add(new ReToken(ReTokenType.CLASS, s));
                continue;
            }
            if (RegexExpression.isStartClass(it)) {
                s = RegexExpression.readClass(it);
                result.add(new ReToken(ReTokenType.CLASS, s));
                continue;
            }
            if (RegexExpression.isSimpleLetter(current)) {
                result.add(new ReToken(ReTokenType.SIMPLE_CHAR, "" + current));
                it.jump();
                continue;
            }
            throw new IllegalStateException();
        }
        return result;
    }

    private static boolean isStartOpenParenthesis(CharInspector it) {
        char current0 = it.peek(0);
        return current0 == '(';
    }

    private static String readOpenParenthesis(CharInspector it) {
        char current0 = it.peek(0);
        it.jump();
        StringBuilder result = new StringBuilder();
        result.append(current0);
        if (it.peek(0) == '?' && it.peek(1) == ':') {
            it.jump();
            it.jump();
            result.append("?:");
        }
        if (it.peek(0) == '?' && it.peek(1) == '!') {
            it.jump();
            it.jump();
            result.append("?!");
        }
        return result.toString();
    }

    private static boolean isStartQuantifier(CharInspector it) {
        char current0 = it.peek(0);
        return current0 == '*' || current0 == '+' || current0 == '?' || current0 == '{';
    }

    private static String readQuantifier(CharInspector it) throws RegexParsingException {
        String result;
        char current0 = it.peek(0);
        it.jump();
        StringBuilder tmp = new StringBuilder();
        tmp.append(current0);
        if (current0 == '{') {
            while (it.peek(0) != '\u0000') {
                char ch = it.peek(0);
                tmp.append(ch);
                it.jump();
                if (ch != '}') continue;
                break;
            }
        }
        if (it.peek(0) == '?') {
            tmp.append('?');
            it.jump();
        }
        if ((result = tmp.toString()).startsWith("{") && !result.matches("^\\{[0-9,]+\\}$")) {
            throw new RegexParsingException("Bad quantifier " + result);
        }
        return result;
    }

    private static boolean isEscapedChar(CharInspector it) {
        char current1;
        char current0 = it.peek(0);
        return current0 == '\\' && ((current1 = it.peek(1)) == '.' || current1 == '*' || current1 == '\\' || current1 == '?' || current1 == '^' || current1 == '$' || current1 == '|' || current1 == '(' || current1 == ')' || current1 == '[' || current1 == ']' || current1 == '{' || current1 == '}' || current1 == '<' || current1 == '>');
    }

    private static String readGroup(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 != '[') {
            throw new IllegalStateException();
        }
        it.jump();
        StringBuilder result = new StringBuilder();
        while (it.peek(0) != '\u0000') {
            char ch = it.peek(0);
            it.jump();
            if (ch == ']') break;
            result.append(ch);
            if (ch != '\\') continue;
            ch = it.peek(0);
            it.jump();
            result.append(ch);
        }
        return result.toString();
    }

    private static String readUnicodeClass(CharInspector it) throws RegexParsingException {
        char current0 = it.peek(0);
        if (current0 != '\\') {
            throw new IllegalStateException();
        }
        it.jump();
        StringBuilder result = new StringBuilder();
        result.append(current0);
        while (it.peek(0) != '\u0000') {
            char ch = it.peek(0);
            it.jump();
            result.append(ch);
            if (ch != '}') continue;
            return result.toString();
        }
        throw new RegexParsingException("Unexpected end of data");
    }

    private static String readUnicodeOrOctalEscape(CharInspector it, int nb) throws RegexParsingException {
        char current0 = it.peek(0);
        if (current0 != '\\') {
            throw new IllegalStateException();
        }
        it.jump();
        StringBuilder result = new StringBuilder();
        result.append(current0);
        for (int i = 0; i < nb; ++i) {
            char ch = it.peek(0);
            if (ch == '\u0000') {
                throw new RegexParsingException("Unexpected end of data");
            }
            result.append(ch);
            it.jump();
        }
        return result.toString();
    }

    private static String readClass(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 == '.') {
            it.jump();
            return "" + current0;
        }
        if (current0 == '\\') {
            it.jump();
            String result = "" + current0 + it.peek(0);
            it.jump();
            return result;
        }
        throw new IllegalStateException();
    }

    private static boolean isStartClass(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 == '.') {
            return true;
        }
        return current0 == '\\';
    }

    private static boolean isStartUnicodeClass(CharInspector it) {
        if (it.peek(0) == '\\' && it.peek(1) == 'p' && it.peek(2) == '{') {
            return true;
        }
        return it.peek(0) == '\\' && it.peek(1) == 'x' && it.peek(2) == '{';
    }

    private static boolean isStartUnicodeEscape(CharInspector it) {
        return it.peek(0) == '\\' && it.peek(1) == 'u';
    }

    private static boolean isStartOctalEscape(CharInspector it) {
        return it.peek(0) == '\\' && it.peek(1) == '0';
    }

    private static boolean isSimpleLetter(char ch) {
        return ch != '\\' && ch != '.';
    }

    private static boolean isStartAnchor(CharInspector it) {
        char current1;
        char current0 = it.peek(0);
        if (current0 == '^' || current0 == '$') {
            return true;
        }
        return current0 == '\\' && ((current1 = it.peek(1)) == 'A' || current1 == 'Z' || current1 == 'z' || current1 == 'G' || current1 == 'b' || current1 == 'B');
    }

    private static String readAnchor(CharInspector it) {
        char current0 = it.peek(0);
        if (current0 == '^' || current0 == '$') {
            it.jump();
            return "" + current0;
        }
        if (current0 == '\\') {
            it.jump();
            String result = "" + current0 + it.peek(0);
            it.jump();
            return result;
        }
        throw new IllegalStateException();
    }
}

