/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.samplers;

import java.util.Objects;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TraceState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.samplers.ImmutableSamplingResult;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.samplers.SamplingDecision;

@Immutable
public interface SamplingResult {
    public static SamplingResult create(SamplingDecision decision) {
        switch (decision) {
            case RECORD_AND_SAMPLE: {
                return ImmutableSamplingResult.EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
            }
            case RECORD_ONLY: {
                return ImmutableSamplingResult.EMPTY_RECORDED_SAMPLING_RESULT;
            }
            case DROP: {
                return ImmutableSamplingResult.EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
            }
        }
        throw new AssertionError((Object)"unrecognised samplingResult");
    }

    public static SamplingResult create(SamplingDecision decision, Attributes attributes) {
        Objects.requireNonNull(attributes, "attributes");
        return attributes.isEmpty() ? SamplingResult.create(decision) : ImmutableSamplingResult.createSamplingResult(decision, attributes);
    }

    public static SamplingResult recordAndSample() {
        return ImmutableSamplingResult.EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
    }

    public static SamplingResult recordOnly() {
        return ImmutableSamplingResult.EMPTY_RECORDED_SAMPLING_RESULT;
    }

    public static SamplingResult drop() {
        return ImmutableSamplingResult.EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
    }

    public SamplingDecision getDecision();

    public Attributes getAttributes();

    default public TraceState getUpdatedTraceState(TraceState parentTraceState) {
        return parentTraceState;
    }
}

