/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.ParallelDownloadConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.ParallelUploadConfig;

final class TransferManagerUtils {
    private TransferManagerUtils() {
    }

    static String createBlobName(ParallelUploadConfig config, Path file) {
        if (config.getPrefix().isEmpty()) {
            return file.toString();
        }
        return config.getPrefix().concat(file.toString());
    }

    static Path createDestPath(ParallelDownloadConfig config, BlobInfo originalBlob) {
        Path newPath = config.getDownloadDirectory().resolve(originalBlob.getName().replaceFirst(config.getStripPrefix(), ""));
        if (Files.exists(newPath.getParent(), new LinkOption[0])) {
            return newPath;
        }
        try {
            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
            return newPath;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }
}

