/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.zip.GZIPOutputStream;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class EventHandler
extends Handler {
    private static final SFLogger logger = SFLoggerFactory.getLogger(EventHandler.class);
    protected static final long LOG_BUFFER_SIZE = 16384L;
    protected static final long FILE_EXPN_TIME_MS = 604800000L;
    protected static final String LOG_DUMP_FILE_NAME = "sf_log_";
    protected static final String LOG_DUMP_FILE_EXT = ".dmp";
    protected static final String LOG_DUMP_COMP_EXT = ".gz";
    protected static final String THROTTLE_DURATION_PROP = "snowflake.throttle_duration";
    protected static final String THROTTLE_LIMIT_PROP = "snowflake.throttle_limit";
    protected static final String DISABLE_DUMPS_PROP = "snowflake.disable_debug_dumps";
    protected static final String MAX_NUM_DUMP_FILES_PROP = "snowflake.max_dumpfiles";
    protected static final String MAX_SIZE_DUMPS_MB_PROP = "snowflake.max_dumpdir_size_mb";
    protected static final String DISABLE_DUMP_COMPR_PROP = "snowflake.disable_log_compression";
    private static final int THROTTLE_DURATION_HRS = SnowflakeUtil.systemGetProperty("snowflake.throttle_duration") == null ? 1 : Integer.valueOf(SnowflakeUtil.systemGetProperty("snowflake.throttle_duration"));
    private static final int INCIDENT_THROTTLE_LIMIT_PER_HR = SnowflakeUtil.systemGetProperty("snowflake.throttle_limit") == null ? 1 : Integer.valueOf(SnowflakeUtil.systemGetProperty("snowflake.throttle_limit"));
    private static final int DEFAULT_MAX_DUMP_FILES = 100;
    private static final int DEFAULT_MAX_DUMPDIR_SIZE_MB = 128;
    private final String logDumpPathPrefix;
    private final int maxEntries;
    private final int flushPeriodMs;
    private final ArrayList<Event> eventBuffer;
    private final ArrayList<LogRecord> logBuffer;
    private ScheduledExecutorService flusher;

    public EventHandler(int maxEntries, int flushPeriodMs) {
        this.maxEntries = maxEntries;
        this.flushPeriodMs = flushPeriodMs;
        this.eventBuffer = new ArrayList();
        this.logBuffer = new ArrayList();
        this.logDumpPathPrefix = EventUtil.getDumpPathPrefix();
    }

    public synchronized int getBufferSize() {
        return this.eventBuffer.size();
    }

    public synchronized long getLogBufferSize() {
        return this.logBuffer.size();
    }

    synchronized void startFlusher() {
        this.flusher = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t2 = Executors.defaultThreadFactory().newThread(r);
                t2.setDaemon(true);
                return t2;
            }
        });
        this.flusher.scheduleWithFixedDelay(new QueueFlusher(), 0L, this.flushPeriodMs, TimeUnit.MILLISECONDS);
    }

    synchronized void stopFlusher() {
        if (this.flusher != null) {
            this.flusher.shutdown();
        }
    }

    private synchronized void pushEvent(Event event, boolean flushBuffer) {
        this.eventBuffer.add(event);
        if (flushBuffer || this.eventBuffer.size() >= this.maxEntries) {
            this.flushEventBuffer();
        }
    }

    void triggerBasicEvent(Event.EventType type, String message) {
        this.triggerBasicEvent(type, message, false);
    }

    void triggerBasicEvent(Event.EventType type, String message, boolean flushBuffer) {
        BasicEvent triggeredEvent = new BasicEvent(type, message);
        this.pushEvent(triggeredEvent, flushBuffer);
    }

    void triggerStateTransition(BasicEvent.QueryState newState, String identifier) {
        String msg = "{newState: " + newState.getDescription() + ", info: " + identifier + ", timestamp: " + EventHandler.getCurrentTimestamp() + "}";
        BasicEvent triggeredEvent = new BasicEvent(Event.EventType.STATE_TRANSITION, msg);
        this.pushEvent(triggeredEvent, false);
    }

    static String getCurrentTimestamp() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return fmt.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLogBuffer(String identifier) {
        PrintWriter logDumper;
        ArrayList<LogRecord> logBufferCopy;
        boolean disableCompression;
        Formatter formatter = this.getFormatter();
        boolean bl = disableCompression = SnowflakeUtil.systemGetProperty(DISABLE_DUMP_COMPR_PROP) != null;
        if (identifier == null) {
            identifier = EventUtil.getDumpFileId();
        }
        this.cleanupSfDumps(true);
        String logDumpPath = this.logDumpPathPrefix + File.separator + LOG_DUMP_FILE_NAME + identifier + LOG_DUMP_FILE_EXT;
        if (!disableCompression) {
            logDumpPath = logDumpPath + LOG_DUMP_COMP_EXT;
        }
        logger.debug("EventHandler dumping log buffer to {}", logDumpPath);
        EventHandler eventHandler = this;
        synchronized (eventHandler) {
            logBufferCopy = new ArrayList<LogRecord>(this.logBuffer);
            this.logBuffer.clear();
        }
        File outputFile = new File(logDumpPath);
        try {
            if (outputFile.getParentFile() != null) {
                outputFile.getParentFile().mkdirs();
            }
            OutputStream outStream = disableCompression ? new FileOutputStream(logDumpPath, false) : new GZIPOutputStream(new FileOutputStream(logDumpPath, false));
            logDumper = new PrintWriter(outStream, true);
        }
        catch (IOException exc) {
            logger.debug("Log dump failed, exception: {}", exc.getMessage());
            return;
        }
        for (LogRecord entry : logBufferCopy) {
            logDumper.write(formatter != null ? formatter.format(entry) : entry.getMessage());
        }
        logDumper.flush();
        logDumper.close();
    }

    protected void cleanupSfDumps(boolean deleteOldest) {
        int maxDumpFiles = SnowflakeUtil.systemGetProperty(MAX_NUM_DUMP_FILES_PROP) != null ? Integer.valueOf(SnowflakeUtil.systemGetProperty(MAX_NUM_DUMP_FILES_PROP)) : 100;
        int maxDumpDirSizeMB = SnowflakeUtil.systemGetProperty(MAX_SIZE_DUMPS_MB_PROP) != null ? Integer.valueOf(SnowflakeUtil.systemGetProperty(MAX_SIZE_DUMPS_MB_PROP)) : 128;
        File dumpDir = new File(this.logDumpPathPrefix);
        long dirSizeBytes = 0L;
        if (dumpDir.listFiles() == null) {
            return;
        }
        TreeSet<File> fileList = new TreeSet<File>(new Comparator<File>(){

            @Override
            public int compare(File a, File b) {
                return a.length() < b.length() ? -1 : 1;
            }
        });
        for (File file : dumpDir.listFiles()) {
            if (!file.getName().startsWith(LOG_DUMP_FILE_NAME) && !file.getName().startsWith("sf_incident_") || System.currentTimeMillis() - file.lastModified() > 604800000L && file.delete()) continue;
            dirSizeBytes += file.length();
            fileList.add(file);
        }
        if (dirSizeBytes >= (long)maxDumpDirSizeMB << 20) {
            for (File file : fileList) {
                if (dirSizeBytes >= (long)maxDumpDirSizeMB << 19) {
                    long victimSize = file.length();
                    if (!file.delete()) continue;
                    dirSizeBytes -= victimSize;
                    continue;
                }
                break;
            }
        } else if (deleteOldest && fileList.size() >= maxDumpFiles) {
            fileList.first().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushEventBuffer() {
        ArrayList<Event> eventBufferCopy;
        logger.debug("Flushing eventBuffer", false);
        EventHandler eventHandler = this;
        synchronized (eventHandler) {
            eventBufferCopy = new ArrayList<Event>(this.eventBuffer);
            this.eventBuffer.clear();
        }
        for (Event event : eventBufferCopy) {
            event.flush();
        }
    }

    @Override
    public synchronized void flush() {
        logger.debug("EventHandler flushing logger buffer", false);
        this.dumpLogBuffer("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void publish(LogRecord record) {
        if (!super.isLoggable(record) || this.getLevel() != null && record.getLevel().intValue() < this.getLevel().intValue()) {
            return;
        }
        ArrayList<LogRecord> arrayList = this.logBuffer;
        synchronized (arrayList) {
            if ((long)this.logBuffer.size() == 16384L) {
                this.logBuffer.remove(0);
            }
            this.logBuffer.add(record);
        }
    }

    @Override
    public void close() {
        this.flushEventBuffer();
        this.stopFlusher();
    }

    private class QueueFlusher
    implements Runnable {
        private QueueFlusher() {
        }

        @Override
        public void run() {
            EventHandler.this.flushEventBuffer();
        }
    }
}

