/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opencensus.metrics.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opencensus.common.Timestamp;
import net.snowflake.client.jdbc.internal.opencensus.internal.Utils;
import net.snowflake.client.jdbc.internal.opencensus.metrics.LabelValue;
import net.snowflake.client.jdbc.internal.opencensus.metrics.export.AutoValue_TimeSeries;
import net.snowflake.client.jdbc.internal.opencensus.metrics.export.Point;

@Immutable
public abstract class TimeSeries {
    TimeSeries() {
    }

    public static TimeSeries create(List<LabelValue> labelValues, List<Point> points, @Nullable Timestamp startTimestamp) {
        Utils.checkListElementNotNull(Utils.checkNotNull(points, "points"), "point");
        return TimeSeries.createInternal(labelValues, Collections.unmodifiableList(new ArrayList<Point>(points)), startTimestamp);
    }

    public static TimeSeries create(List<LabelValue> labelValues) {
        return TimeSeries.createInternal(labelValues, Collections.emptyList(), null);
    }

    public static TimeSeries createWithOnePoint(List<LabelValue> labelValues, Point point, @Nullable Timestamp startTimestamp) {
        Utils.checkNotNull(point, "point");
        return TimeSeries.createInternal(labelValues, Collections.singletonList(point), startTimestamp);
    }

    public TimeSeries setPoint(Point point) {
        Utils.checkNotNull(point, "point");
        return new AutoValue_TimeSeries(this.getLabelValues(), Collections.singletonList(point), null);
    }

    private static TimeSeries createInternal(List<LabelValue> labelValues, List<Point> points, @Nullable Timestamp startTimestamp) {
        Utils.checkListElementNotNull(Utils.checkNotNull(labelValues, "labelValues"), "labelValue");
        return new AutoValue_TimeSeries(Collections.unmodifiableList(new ArrayList<LabelValue>(labelValues)), points, startTimestamp);
    }

    public abstract List<LabelValue> getLabelValues();

    public abstract List<Point> getPoints();

    @Nullable
    public abstract Timestamp getStartTimestamp();
}

