/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.retrying;

import java.io.InterruptedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.Callable;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.BasicRetryingFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.NoopRetryingContext;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetryAlgorithm;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetryingContext;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetryingExecutorWithContext;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetryingFuture;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.threeten.bp.Duration;

public class DirectRetryingExecutor<ResponseT>
implements RetryingExecutorWithContext<ResponseT> {
    private final RetryAlgorithm<ResponseT> retryAlgorithm;

    public DirectRetryingExecutor(RetryAlgorithm<ResponseT> retryAlgorithm) {
        this.retryAlgorithm = Preconditions.checkNotNull(retryAlgorithm);
    }

    @Override
    public RetryingFuture<ResponseT> createFuture(Callable<ResponseT> callable) {
        return this.createFuture(callable, NoopRetryingContext.create());
    }

    @Override
    public RetryingFuture<ResponseT> createFuture(Callable<ResponseT> callable, RetryingContext context) {
        return new BasicRetryingFuture<ResponseT>(callable, this.retryAlgorithm, context);
    }

    @Override
    public ApiFuture<ResponseT> submit(RetryingFuture<ResponseT> retryingFuture) {
        while (!retryingFuture.isDone()) {
            try {
                this.sleep(retryingFuture.getAttemptSettings().getRandomizedRetryDelay());
                ResponseT response = retryingFuture.getCallable().call();
                retryingFuture.setAttemptFuture(ApiFutures.immediateFuture(response));
            }
            catch (InterruptedIOException | InterruptedException | ClosedByInterruptException e) {
                Thread.currentThread().interrupt();
                retryingFuture.setAttemptFuture(ApiFutures.immediateFailedFuture(e));
            }
            catch (Exception e) {
                retryingFuture.setAttemptFuture(ApiFutures.immediateFailedFuture(e));
            }
        }
        return retryingFuture;
    }

    protected void sleep(Duration delay) throws InterruptedException {
        if (Duration.ZERO.compareTo(delay) < 0) {
            Thread.sleep(delay.toMillis());
        }
    }
}

