/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.client.googleapis.auth.oauth2;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.Locale;
import net.snowflake.client.jdbc.internal.google.api.client.auth.oauth2.TokenResponse;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.auth.oauth2.CloudShellCredential;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.auth.oauth2.OAuth2Utils;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.auth.oauth2.SystemEnvironmentProvider;
import net.snowflake.client.jdbc.internal.google.api.client.http.GenericUrl;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpRequest;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpResponse;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpTransport;
import net.snowflake.client.jdbc.internal.google.api.client.json.JsonFactory;
import net.snowflake.client.jdbc.internal.google.api.client.json.JsonObjectParser;
import net.snowflake.client.jdbc.internal.google.api.client.util.Beta;

@Beta
class DefaultCredentialProvider
extends SystemEnvironmentProvider {
    static final String CREDENTIAL_ENV_VAR = "GOOGLE_APPLICATION_CREDENTIALS";
    static final String WELL_KNOWN_CREDENTIALS_FILE = "application_default_credentials.json";
    static final String CLOUDSDK_CONFIG_DIRECTORY = "gcloud";
    static final String HELP_PERMALINK = "https://developers.google.com/accounts/docs/application-default-credentials";
    static final String APP_ENGINE_CREDENTIAL_CLASS = "net.snowflake.client.jdbc.internal.google.api.client.googleapis.extensions.appengine.auth.oauth2.AppIdentityCredential$AppEngineCredentialWrapper";
    static final String CLOUD_SHELL_ENV_VAR = "DEVSHELL_CLIENT_PORT";
    private GoogleCredential cachedCredential = null;
    private Environment detectedEnvironment = null;

    DefaultCredentialProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final GoogleCredential getDefaultCredential(HttpTransport transport, JsonFactory jsonFactory) throws IOException {
        DefaultCredentialProvider defaultCredentialProvider = this;
        synchronized (defaultCredentialProvider) {
            if (this.cachedCredential == null) {
                this.cachedCredential = this.getDefaultCredentialUnsynchronized(transport, jsonFactory);
            }
            if (this.cachedCredential != null) {
                return this.cachedCredential;
            }
        }
        throw new IOException(String.format("The Application Default Credentials are not available. They are available if running on Google App Engine, Google Compute Engine, or Google Cloud Shell. Otherwise, the environment variable %s must be defined pointing to a file defining the credentials. See %s for more information.", CREDENTIAL_ENV_VAR, HELP_PERMALINK));
    }

    private final GoogleCredential getDefaultCredentialUnsynchronized(HttpTransport transport, JsonFactory jsonFactory) throws IOException {
        if (this.detectedEnvironment == null) {
            this.detectedEnvironment = this.detectEnvironment(transport);
        }
        switch (this.detectedEnvironment) {
            case ENVIRONMENT_VARIABLE: {
                return this.getCredentialUsingEnvironmentVariable(transport, jsonFactory);
            }
            case WELL_KNOWN_FILE: {
                return this.getCredentialUsingWellKnownFile(transport, jsonFactory);
            }
            case APP_ENGINE: {
                return this.getAppEngineCredential(transport, jsonFactory);
            }
            case CLOUD_SHELL: {
                return this.getCloudShellCredential(jsonFactory);
            }
            case COMPUTE_ENGINE: {
                return this.getComputeCredential(transport, jsonFactory);
            }
        }
        return null;
    }

    private final File getWellKnownCredentialsFile() {
        File cloudConfigPath = null;
        String os = this.getProperty("os.name", "").toLowerCase(Locale.US);
        if (os.indexOf("windows") >= 0) {
            File appDataPath = new File(this.getEnv("APPDATA"));
            cloudConfigPath = new File(appDataPath, CLOUDSDK_CONFIG_DIRECTORY);
        } else {
            File configPath = new File(this.getProperty("user.home", ""), ".config");
            cloudConfigPath = new File(configPath, CLOUDSDK_CONFIG_DIRECTORY);
        }
        File credentialFilePath = new File(cloudConfigPath, WELL_KNOWN_CREDENTIALS_FILE);
        return credentialFilePath;
    }

    boolean fileExists(File file) {
        return file.exists() && !file.isDirectory();
    }

    String getProperty(String property, String def) {
        return System.getProperty(property, def);
    }

    Class<?> forName(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    private final Environment detectEnvironment(HttpTransport transport) throws IOException {
        if (this.runningUsingEnvironmentVariable()) {
            return Environment.ENVIRONMENT_VARIABLE;
        }
        if (this.runningUsingWellKnownFile()) {
            return Environment.WELL_KNOWN_FILE;
        }
        if (this.useGAEStandardAPI()) {
            return Environment.APP_ENGINE;
        }
        if (this.runningOnCloudShell()) {
            return Environment.CLOUD_SHELL;
        }
        if (OAuth2Utils.runningOnComputeEngine(transport, this)) {
            return Environment.COMPUTE_ENGINE;
        }
        return Environment.UNKNOWN;
    }

    private boolean runningUsingEnvironmentVariable() throws IOException {
        String credentialsPath = this.getEnv(CREDENTIAL_ENV_VAR);
        if (credentialsPath == null || credentialsPath.length() == 0) {
            return false;
        }
        try {
            File credentialsFile = new File(credentialsPath);
            if (!credentialsFile.exists() || credentialsFile.isDirectory()) {
                throw new IOException(String.format("Error reading credential file from environment variable %s, value '%s': File does not exist.", CREDENTIAL_ENV_VAR, credentialsPath));
            }
            return true;
        }
        catch (AccessControlException expected) {
            return false;
        }
    }

    private GoogleCredential getCredentialUsingEnvironmentVariable(HttpTransport transport, JsonFactory jsonFactory) throws IOException {
        String credentialsPath = this.getEnv(CREDENTIAL_ENV_VAR);
        try (FileInputStream credentialsStream = null;){
            credentialsStream = new FileInputStream(credentialsPath);
            GoogleCredential googleCredential = GoogleCredential.fromStream(credentialsStream, transport, jsonFactory);
            return googleCredential;
        }
    }

    private boolean runningUsingWellKnownFile() {
        File wellKnownFileLocation = this.getWellKnownCredentialsFile();
        try {
            return this.fileExists(wellKnownFileLocation);
        }
        catch (AccessControlException expected) {
            return false;
        }
    }

    private GoogleCredential getCredentialUsingWellKnownFile(HttpTransport transport, JsonFactory jsonFactory) throws IOException {
        File wellKnownFileLocation = this.getWellKnownCredentialsFile();
        try (FileInputStream credentialsStream = null;){
            credentialsStream = new FileInputStream(wellKnownFileLocation);
            GoogleCredential googleCredential = GoogleCredential.fromStream(credentialsStream, transport, jsonFactory);
            return googleCredential;
        }
    }

    private boolean useGAEStandardAPI() {
        Class<?> systemPropertyClass = null;
        try {
            systemPropertyClass = this.forName("net.snowflake.client.jdbc.internal.google.appengine.api.utils.SystemProperty");
        }
        catch (ClassNotFoundException expected) {
            return false;
        }
        Exception cause = null;
        try {
            Field environmentField = systemPropertyClass.getField("environment");
            Object environmentValue = environmentField.get(null);
            Class<?> environmentType = environmentField.getType();
            Method valueMethod = environmentType.getMethod("value", new Class[0]);
            Object environmentValueValue = valueMethod.invoke(environmentValue, new Object[0]);
            return environmentValueValue != null;
        }
        catch (NoSuchFieldException exception) {
            cause = exception;
        }
        catch (SecurityException exception) {
            cause = exception;
        }
        catch (IllegalArgumentException exception) {
            cause = exception;
        }
        catch (IllegalAccessException exception) {
            cause = exception;
        }
        catch (NoSuchMethodException exception) {
            cause = exception;
        }
        catch (InvocationTargetException exception) {
            cause = exception;
        }
        throw OAuth2Utils.exceptionWithCause(new RuntimeException(String.format("Unexpcted error trying to determine if runnning on Google App Engine: %s", cause.getMessage())), cause);
    }

    private final GoogleCredential getAppEngineCredential(HttpTransport transport, JsonFactory jsonFactory) throws IOException {
        ReflectiveOperationException innerException = null;
        try {
            Class<?> credentialClass = this.forName(APP_ENGINE_CREDENTIAL_CLASS);
            Constructor<?> constructor = credentialClass.getConstructor(HttpTransport.class, JsonFactory.class);
            return (GoogleCredential)constructor.newInstance(transport, jsonFactory);
        }
        catch (ClassNotFoundException e) {
            innerException = e;
        }
        catch (NoSuchMethodException e) {
            innerException = e;
        }
        catch (InstantiationException e) {
            innerException = e;
        }
        catch (IllegalAccessException e) {
            innerException = e;
        }
        catch (InvocationTargetException e) {
            innerException = e;
        }
        throw OAuth2Utils.exceptionWithCause(new IOException(String.format("Application Default Credentials failed to create the Google App Engine service account credentials class %s. Check that the component 'google-api-client-appengine' is deployed.", APP_ENGINE_CREDENTIAL_CLASS)), innerException);
    }

    private boolean runningOnCloudShell() {
        return this.getEnv(CLOUD_SHELL_ENV_VAR) != null;
    }

    private GoogleCredential getCloudShellCredential(JsonFactory jsonFactory) {
        String port = this.getEnv(CLOUD_SHELL_ENV_VAR);
        return new CloudShellCredential(Integer.parseInt(port), jsonFactory);
    }

    private final GoogleCredential getComputeCredential(HttpTransport transport, JsonFactory jsonFactory) {
        return new ComputeGoogleCredential(transport, jsonFactory);
    }

    private static class ComputeGoogleCredential
    extends GoogleCredential {
        private static final String TOKEN_SERVER_ENCODED_URL = OAuth2Utils.getMetadataServerUrl() + "/computeMetadata/v1/instance/service-accounts/default/token";

        ComputeGoogleCredential(HttpTransport transport, JsonFactory jsonFactory) {
            super(new GoogleCredential.Builder().setTransport(transport).setJsonFactory(jsonFactory).setTokenServerEncodedUrl(TOKEN_SERVER_ENCODED_URL));
        }

        @Override
        protected TokenResponse executeRefreshToken() throws IOException {
            GenericUrl tokenUrl = new GenericUrl(this.getTokenServerEncodedUrl());
            HttpRequest request = this.getTransport().createRequestFactory().buildGetRequest(tokenUrl);
            JsonObjectParser parser = new JsonObjectParser(this.getJsonFactory());
            request.setParser(parser);
            request.getHeaders().set("Metadata-Flavor", "Google");
            request.setThrowExceptionOnExecuteError(false);
            HttpResponse response = request.execute();
            int statusCode = response.getStatusCode();
            if (statusCode == 200) {
                InputStream content = response.getContent();
                if (content == null) {
                    throw new IOException("Empty content from metadata token server request.");
                }
                return parser.parseAndClose(content, response.getContentCharset(), TokenResponse.class);
            }
            if (statusCode == 404) {
                throw new IOException(String.format("Error code %s trying to get security access token from Compute Engine metadata for the default service account. This may be because the virtual machine instance does not have permission scopes specified.", statusCode));
            }
            throw new IOException(String.format("Unexpected Error code %s trying to get security access token from Compute Engine metadata for the default service account: %s", statusCode, response.parseAsString()));
        }
    }

    private static enum Environment {
        UNKNOWN,
        ENVIRONMENT_VARIABLE,
        WELL_KNOWN_FILE,
        CLOUD_SHELL,
        APP_ENGINE,
        COMPUTE_ENGINE;

    }
}

