/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage;

import java.util.EnumSet;

public enum SharedAccessAccountPermissions {
    READ('r'),
    ADD('a'),
    CREATE('c'),
    WRITE('w'),
    DELETE('d'),
    LIST('l'),
    UPDATE('u'),
    PROCESS_MESSAGES('p');

    private final char value;

    private SharedAccessAccountPermissions(char c) {
        this.value = c;
    }

    static String permissionsToString(EnumSet<SharedAccessAccountPermissions> permissions) {
        if (permissions == null) {
            return "";
        }
        StringBuilder value = new StringBuilder();
        for (SharedAccessAccountPermissions perm : permissions) {
            value.append(perm.value);
        }
        return value.toString();
    }

    static EnumSet<SharedAccessAccountPermissions> permissionsFromString(String permString) {
        EnumSet<SharedAccessAccountPermissions> permissions = EnumSet.noneOf(SharedAccessAccountPermissions.class);
        for (char c : permString.toLowerCase().toCharArray()) {
            boolean invalidCharacter = true;
            for (SharedAccessAccountPermissions perm : SharedAccessAccountPermissions.values()) {
                if (c != perm.value) continue;
                permissions.add(perm);
                invalidCharacter = false;
                break;
            }
            if (!invalidCharacter) continue;
            throw new IllegalArgumentException(String.format("%s could not be parsed from '%s'.", "Permissions", permString));
        }
        return permissions;
    }
}

