/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud;

import java.util.Arrays;
import java.util.Collection;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.cloud.AutoValue_Binding;
import net.snowflake.client.jdbc.internal.google.cloud.Condition;
import net.snowflake.client.jdbc.internal.google.common.base.Predicate;
import net.snowflake.client.jdbc.internal.google.common.base.Predicates;
import net.snowflake.client.jdbc.internal.google.common.collect.Collections2;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.common.collect.Lists;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@BetaApi(value="This is a Beta API is not stable yet and may change in the future.")
@AutoValue
public abstract class Binding {
    public abstract String getRole();

    public abstract ImmutableList<String> getMembers();

    @Nullable
    public abstract Condition getCondition();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        ImmutableList<String> emptyMembers = ImmutableList.of();
        return new AutoValue_Binding.Builder().setMembers(emptyMembers);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRole(String var1);

        public abstract Builder setMembers(Iterable<String> var1);

        public abstract Builder setCondition(Condition var1);

        abstract ImmutableList<String> getMembers();

        public Builder addMembers(String member, String ... moreMembers) {
            ImmutableList.Builder membersBuilder = ImmutableList.builder();
            membersBuilder.addAll(this.getMembers());
            membersBuilder.addAll(Lists.asList(member, moreMembers));
            this.setMembers(membersBuilder.build());
            return this;
        }

        public Builder removeMembers(String ... members) {
            Predicate<String> selectMembersNotInList = Predicates.not(Predicates.in(Arrays.asList(members)));
            Collection<String> filter = Collections2.filter(this.getMembers(), selectMembersNotInList);
            this.setMembers(filter);
            return this;
        }

        public abstract Binding build();
    }
}

