/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.ApiMessage;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.AutoValue_ApiMessageHttpRequestFormatter;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.FieldMaskedSerializer;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpRequestFormatter;
import net.snowflake.client.jdbc.internal.google.api.pathtemplate.PathTemplate;
import net.snowflake.client.jdbc.internal.google.api.resourcenames.ResourceNameFactory;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.common.collect.Lists;
import net.snowflake.client.jdbc.internal.google.gson.GsonBuilder;

@BetaApi
@AutoValue
public abstract class ApiMessageHttpRequestFormatter<RequestT extends ApiMessage>
implements HttpRequestFormatter<RequestT> {
    public abstract String getResourceNameField();

    public abstract ResourceNameFactory getResourceNameFactory();

    public abstract Set<String> getQueryParamNames();

    @Override
    public abstract PathTemplate getPathTemplate();

    private static <RequestT extends ApiMessage> ApiMessageHttpRequestFormatter<RequestT> create(Set<String> queryParams, String resourceNameField, ResourceNameFactory resourceNameFactory, PathTemplate pathTemplate) {
        return new AutoValue_ApiMessageHttpRequestFormatter(resourceNameField, resourceNameFactory, queryParams, pathTemplate);
    }

    public static <RequestT extends ApiMessage> Builder<RequestT> newBuilder() {
        return new Builder();
    }

    @Override
    public Map<String, List<String>> getQueryParamNames(RequestT apiMessage) {
        Set<String> paramNames = this.getQueryParamNames();
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        HashMap<String, ArrayList<Object>> nullableParams = new HashMap<String, ArrayList<Object>>();
        for (String paramName : paramNames) {
            ArrayList<Object> valueList;
            Object paramValue = apiMessage.getFieldValue(paramName);
            if (paramValue == null) continue;
            if (paramValue instanceof List) {
                valueList = new ArrayList();
                for (Object val : (List)paramValue) {
                    valueList.add(val.toString());
                }
            } else {
                valueList = Lists.newArrayList(paramValue.toString());
            }
            nullableParams.put(paramName, valueList);
        }
        for (Map.Entry pair : nullableParams.entrySet()) {
            if (pair.getValue() == null || ((List)pair.getValue()).size() <= 0 || ((List)pair.getValue()).get(0) == null) continue;
            queryParams.put((String)pair.getKey(), (List<String>)pair.getValue());
        }
        return queryParams;
    }

    @Override
    public String getRequestBody(ApiMessage apiMessage) {
        ApiMessage body = apiMessage.getApiMessageRequestBody();
        if (body == null) {
            return null;
        }
        GsonBuilder requestMarshaller = new GsonBuilder();
        if (apiMessage.getFieldMask() != null) {
            requestMarshaller.registerTypeAdapter(body.getClass(), new FieldMaskedSerializer(apiMessage.getFieldMask())).serializeNulls();
        }
        return requestMarshaller.create().toJson(body);
    }

    @Override
    public String getPath(RequestT apiMessage) {
        Map<String, String> pathParams = this.getPathParams(apiMessage);
        return this.getPathTemplate().instantiate(pathParams);
    }

    private Map<String, String> getPathParams(RequestT apiMessage) {
        Object fieldValue = apiMessage.getFieldValue(this.getResourceNameField());
        if (fieldValue == null) {
            throw new IllegalArgumentException(String.format("Resource name field %s is null in message object.", this.getResourceNameField()));
        }
        String resourceNamePath = fieldValue.toString();
        return this.getResourceNameFactory().parse(resourceNamePath).getFieldValuesMap();
    }

    public static class Builder<RequestT extends ApiMessage> {
        private String resourceNameField;
        private ResourceNameFactory resourceNameFactory;
        private Set<String> queryParams;
        private PathTemplate pathTemplate;

        private Builder() {
        }

        public Builder<RequestT> setResourceNameField(String resourceNameField) {
            this.resourceNameField = resourceNameField;
            return this;
        }

        public Builder<RequestT> setResourceNameFactory(ResourceNameFactory resourceNameFactory) {
            this.resourceNameFactory = resourceNameFactory;
            return this;
        }

        public Builder<RequestT> setPathTemplate(PathTemplate pathTemplate) {
            this.pathTemplate = pathTemplate;
            return this;
        }

        public Builder<RequestT> setQueryParams(Set<String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public ApiMessageHttpRequestFormatter<RequestT> build() {
            return ApiMessageHttpRequestFormatter.create(this.queryParams, this.resourceNameField, this.resourceNameFactory, this.pathTemplate);
        }
    }
}

