/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.net.minidev.json;

import java.io.IOException;

class JStylerObj {
    public static final MPSimple MP_SIMPLE = new MPSimple();
    public static final MPTrue MP_TRUE = new MPTrue();
    public static final MPAgressive MP_AGGRESIVE = new MPAgressive();
    public static final EscapeLT ESCAPE_LT = new EscapeLT();
    public static final Escape4Web ESCAPE4Web = new Escape4Web();

    JStylerObj() {
    }

    public static boolean isSpace(char c) {
        return c == '\r' || c == '\n' || c == '\t' || c == ' ';
    }

    public static boolean isSpecialChar(char c) {
        return c == '\b' || c == '\f' || c == '\n';
    }

    public static boolean isSpecialOpen(char c) {
        return c == '{' || c == '[' || c == ',' || c == ':';
    }

    public static boolean isSpecialClose(char c) {
        return c == '}' || c == ']' || c == ',' || c == ':';
    }

    public static boolean isSpecial(char c) {
        return c == '{' || c == '[' || c == ',' || c == '}' || c == ']' || c == ':' || c == '\'' || c == '\"';
    }

    public static boolean isUnicode(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff';
    }

    public static boolean isKeyword(String s2) {
        if (s2.length() < 3) {
            return false;
        }
        char c = s2.charAt(0);
        if (c == 'n') {
            return s2.equals("null");
        }
        if (c == 't') {
            return s2.equals("true");
        }
        if (c == 'f') {
            return s2.equals("false");
        }
        if (c == 'N') {
            return s2.equals("NaN");
        }
        return false;
    }

    private static class Escape4Web
    implements StringProtector {
        private Escape4Web() {
        }

        @Override
        public void escape(String s2, Appendable sb) {
            try {
                int len = s2.length();
                int i = 0;
                while (i < len) {
                    char ch = s2.charAt(i);
                    switch (ch) {
                        case '\"': {
                            sb.append("\\\"");
                            break;
                        }
                        case '\\': {
                            sb.append("\\\\");
                            break;
                        }
                        case '\b': {
                            sb.append("\\b");
                            break;
                        }
                        case '\f': {
                            sb.append("\\f");
                            break;
                        }
                        case '\n': {
                            sb.append("\\n");
                            break;
                        }
                        case '\r': {
                            sb.append("\\r");
                            break;
                        }
                        case '\t': {
                            sb.append("\\t");
                            break;
                        }
                        case '/': {
                            sb.append("\\/");
                            break;
                        }
                        default: {
                            if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                                sb.append("\\u");
                                String hex = "0123456789ABCDEF";
                                sb.append(hex.charAt(ch >> 12 & 0xF));
                                sb.append(hex.charAt(ch >> 8 & 0xF));
                                sb.append(hex.charAt(ch >> 4 & 0xF));
                                sb.append(hex.charAt(ch >> 0 & 0xF));
                                break;
                            }
                            sb.append(ch);
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Impossible Error");
            }
        }
    }

    private static class EscapeLT
    implements StringProtector {
        private EscapeLT() {
        }

        @Override
        public void escape(String s2, Appendable out) {
            try {
                int len = s2.length();
                int i = 0;
                while (i < len) {
                    char ch = s2.charAt(i);
                    switch (ch) {
                        case '\"': {
                            out.append("\\\"");
                            break;
                        }
                        case '\\': {
                            out.append("\\\\");
                            break;
                        }
                        case '\b': {
                            out.append("\\b");
                            break;
                        }
                        case '\f': {
                            out.append("\\f");
                            break;
                        }
                        case '\n': {
                            out.append("\\n");
                            break;
                        }
                        case '\r': {
                            out.append("\\r");
                            break;
                        }
                        case '\t': {
                            out.append("\\t");
                            break;
                        }
                        default: {
                            if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                                out.append("\\u");
                                String hex = "0123456789ABCDEF";
                                out.append(hex.charAt(ch >> 12 & 0xF));
                                out.append(hex.charAt(ch >> 8 & 0xF));
                                out.append(hex.charAt(ch >> 4 & 0xF));
                                out.append(hex.charAt(ch >> 0 & 0xF));
                                break;
                            }
                            out.append(ch);
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Impossible Exeption");
            }
        }
    }

    private static class MPAgressive
    implements MustProtect {
        private MPAgressive() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean mustBeProtect(String s) {
            block16: {
                if (s == null) {
                    return false;
                }
                len = s.length();
                if (len == 0) {
                    return true;
                }
                if (s.trim() != s) {
                    return true;
                }
                ch = s.charAt(0);
                if (JStylerObj.isSpecial(ch) || JStylerObj.isUnicode(ch)) {
                    return true;
                }
                i = 1;
                while (i < len) {
                    ch = s.charAt(i);
                    if (JStylerObj.isSpecialClose(ch) || JStylerObj.isUnicode(ch)) {
                        return true;
                    }
                    ++i;
                }
                if (JStylerObj.isKeyword(s)) {
                    return true;
                }
                ch = s.charAt(0);
                if ((ch < '0' || ch > '9') && ch != '-') break block16;
                p = 1;
                while (p < len) {
                    ch = s.charAt(p);
                    if (ch < '0' || ch > '9') break;
                    ++p;
                }
                if (p == len) {
                    return true;
                }
                if (ch == '.') {
                    ++p;
                }
                while (p < len) {
                    ch = s.charAt(p);
                    if (ch < '0' || ch > '9') break;
                    ++p;
                }
                if (p == len) {
                    return true;
                }
                if (ch == 'E' || ch == 'e') {
                    if (++p == len) {
                        return false;
                    }
                    ch = s.charAt(p);
                    if (ch == '+' || ch == '-') {
                        ch = s.charAt(++p);
                    }
                }
                if (p != len) ** GOTO lbl49
                return false;
                while ((ch = s.charAt(p)) >= '0' && ch <= '9') {
                    ++p;
lbl49:
                    // 2 sources

                    if (p < len) continue;
                }
                return p == len;
            }
            return false;
        }
    }

    private static class MPSimple
    implements MustProtect {
        private MPSimple() {
        }

        @Override
        public boolean mustBeProtect(String s2) {
            if (s2 == null) {
                return false;
            }
            int len = s2.length();
            if (len == 0) {
                return true;
            }
            if (s2.trim() != s2) {
                return true;
            }
            char ch = s2.charAt(0);
            if (ch >= '0' && ch <= '9' || ch == '-') {
                return true;
            }
            int i = 0;
            while (i < len) {
                ch = s2.charAt(i);
                if (JStylerObj.isSpace(ch)) {
                    return true;
                }
                if (JStylerObj.isSpecial(ch)) {
                    return true;
                }
                if (JStylerObj.isSpecialChar(ch)) {
                    return true;
                }
                if (JStylerObj.isUnicode(ch)) {
                    return true;
                }
                ++i;
            }
            return JStylerObj.isKeyword(s2);
        }
    }

    private static class MPTrue
    implements MustProtect {
        private MPTrue() {
        }

        @Override
        public boolean mustBeProtect(String s2) {
            return true;
        }
    }

    public static interface MustProtect {
        public boolean mustBeProtect(String var1);
    }

    public static interface StringProtector {
        public void escape(String var1, Appendable var2);
    }
}

