/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jwt;

import java.text.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.Algorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.Header;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWEAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.EncryptedJWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.PlainJWT;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.SignedJWT;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

public final class JWTParser {
    public static JWT parse(String s2) throws ParseException {
        JSONObject jsonObject;
        int firstDotPos = s2.indexOf(".");
        if (firstDotPos == -1) {
            throw new ParseException("Invalid JWT serialization: Missing dot delimiter(s)", 0);
        }
        Base64URL header = new Base64URL(s2.substring(0, firstDotPos));
        try {
            jsonObject = JSONObjectUtils.parse(header.decodeToString());
        }
        catch (ParseException e) {
            throw new ParseException("Invalid unsecured/JWS/JWE header: " + e.getMessage(), 0);
        }
        Algorithm alg = Header.parseAlgorithm(jsonObject);
        if (alg.equals(Algorithm.NONE)) {
            return PlainJWT.parse(s2);
        }
        if (alg instanceof JWSAlgorithm) {
            return SignedJWT.parse(s2);
        }
        if (alg instanceof JWEAlgorithm) {
            return EncryptedJWT.parse(s2);
        }
        throw new AssertionError((Object)("Unexpected algorithm type: " + alg));
    }

    private JWTParser() {
    }
}

