/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.http.timers.request;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkTestInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.ThreadSafe;
import net.snowflake.client.jdbc.internal.amazonaws.http.timers.TimeoutThreadPoolBuilder;
import net.snowflake.client.jdbc.internal.amazonaws.http.timers.request.HttpRequestAbortTaskImpl;
import net.snowflake.client.jdbc.internal.amazonaws.http.timers.request.HttpRequestAbortTaskTracker;
import net.snowflake.client.jdbc.internal.amazonaws.http.timers.request.HttpRequestAbortTaskTrackerImpl;
import net.snowflake.client.jdbc.internal.amazonaws.http.timers.request.NoOpHttpRequestAbortTaskTracker;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;

@ThreadSafe
@SdkInternalApi
public class HttpRequestTimer {
    private static final String threadNamePrefix = "AwsSdkRequestTimerThread";
    private volatile ScheduledThreadPoolExecutor executor;

    public HttpRequestAbortTaskTracker startTimer(HttpRequestBase apacheRequest, int requestTimeoutMillis) {
        if (this.isTimeoutDisabled(requestTimeoutMillis)) {
            return NoOpHttpRequestAbortTaskTracker.INSTANCE;
        }
        if (this.executor == null) {
            this.initializeExecutor();
        }
        HttpRequestAbortTaskImpl timerTask = new HttpRequestAbortTaskImpl(apacheRequest);
        ScheduledFuture<?> timerTaskFuture = this.executor.schedule(timerTask, (long)requestTimeoutMillis, TimeUnit.MILLISECONDS);
        return new HttpRequestAbortTaskTrackerImpl(timerTask, timerTaskFuture);
    }

    private boolean isTimeoutDisabled(int requestTimeoutMillis) {
        return requestTimeoutMillis <= 0;
    }

    private synchronized void initializeExecutor() {
        if (this.executor == null) {
            this.executor = TimeoutThreadPoolBuilder.buildDefaultTimeoutThreadPool(threadNamePrefix);
        }
    }

    public synchronized void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @SdkTestInternalApi
    public ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }
}

