/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StagedFileWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StagedFileWrapper.class);
    private String path;
    private Long size;

    public StagedFileWrapper(String filepath, Long filesize) {
        if (filepath == null) {
            LOGGER.error("Null filepath provided");
            throw new IllegalArgumentException();
        }
        if (filesize != null && filesize < 0L) {
            LOGGER.error("Negative file size provided");
            throw new IllegalArgumentException();
        }
        this.path = filepath;
        this.size = filesize;
    }

    public StagedFileWrapper(String filepath) {
        this(filepath, null);
    }

    public String getPath() {
        return this.path;
    }

    public Long getSize() {
        return this.size;
    }
}

