/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.nio.protocol;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.http.HttpException;
import net.snowflake.ingest.internal.apache.http.HttpRequest;
import net.snowflake.ingest.internal.apache.http.annotation.Contract;
import net.snowflake.ingest.internal.apache.http.annotation.ThreadingBehavior;
import net.snowflake.ingest.internal.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import net.snowflake.ingest.internal.apache.http.nio.protocol.HttpAsyncExchange;
import net.snowflake.ingest.internal.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import net.snowflake.ingest.internal.apache.http.nio.protocol.HttpAsyncRequestHandler;
import net.snowflake.ingest.internal.apache.http.protocol.HttpContext;
import net.snowflake.ingest.internal.apache.http.protocol.HttpRequestHandler;
import net.snowflake.ingest.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicAsyncRequestHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpRequestHandler handler;

    public BasicAsyncRequestHandler(HttpRequestHandler handler) {
        Args.notNull(handler, "Request handler");
        this.handler = handler;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(HttpRequest request, HttpAsyncExchange httpexchange, HttpContext context) throws HttpException, IOException {
        this.handler.handle(request, httpexchange.getResponse(), context);
        httpexchange.submitResponse();
    }
}

