/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.impl.nio.conn;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.concurrent.atomic.AtomicLong;
import net.snowflake.ingest.internal.apache.commons.logging.Log;
import net.snowflake.ingest.internal.apache.commons.logging.LogFactory;
import net.snowflake.ingest.internal.apache.http.HttpRequest;
import net.snowflake.ingest.internal.apache.http.HttpResponse;
import net.snowflake.ingest.internal.apache.http.config.ConnectionConfig;
import net.snowflake.ingest.internal.apache.http.impl.nio.codecs.DefaultHttpRequestWriterFactory;
import net.snowflake.ingest.internal.apache.http.impl.nio.codecs.DefaultHttpResponseParserFactory;
import net.snowflake.ingest.internal.apache.http.impl.nio.conn.ManagedNHttpClientConnectionImpl;
import net.snowflake.ingest.internal.apache.http.nio.NHttpMessageParserFactory;
import net.snowflake.ingest.internal.apache.http.nio.NHttpMessageWriterFactory;
import net.snowflake.ingest.internal.apache.http.nio.conn.ManagedNHttpClientConnection;
import net.snowflake.ingest.internal.apache.http.nio.conn.NHttpConnectionFactory;
import net.snowflake.ingest.internal.apache.http.nio.reactor.IOSession;
import net.snowflake.ingest.internal.apache.http.nio.util.ByteBufferAllocator;
import net.snowflake.ingest.internal.apache.http.nio.util.HeapByteBufferAllocator;

public class ManagedNHttpClientConnectionFactory
implements NHttpConnectionFactory<ManagedNHttpClientConnection> {
    private final Log headerlog = LogFactory.getLog("net.snowflake.ingest.internal.apache.http.headers");
    private final Log wirelog = LogFactory.getLog("net.snowflake.ingest.internal.apache.http.wire");
    private final Log log = LogFactory.getLog(ManagedNHttpClientConnectionImpl.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    public static final ManagedNHttpClientConnectionFactory INSTANCE = new ManagedNHttpClientConnectionFactory();
    private final ByteBufferAllocator allocator;
    private final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final NHttpMessageParserFactory<HttpResponse> responseParserFactory;

    public ManagedNHttpClientConnectionFactory(NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, NHttpMessageParserFactory<HttpResponse> responseParserFactory, ByteBufferAllocator allocator) {
        this.requestWriterFactory = requestWriterFactory != null ? requestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE;
        this.responseParserFactory = responseParserFactory != null ? responseParserFactory : DefaultHttpResponseParserFactory.INSTANCE;
        this.allocator = allocator != null ? allocator : HeapByteBufferAllocator.INSTANCE;
    }

    public ManagedNHttpClientConnectionFactory() {
        this(null, null, null);
    }

    @Override
    public ManagedNHttpClientConnection create(IOSession iosession, ConnectionConfig config) {
        CodingErrorAction unmappableInputAction;
        String id = "http-outgoing-" + Long.toString(COUNTER.getAndIncrement());
        CharsetDecoder chardecoder = null;
        CharsetEncoder charencoder = null;
        Charset charset = config.getCharset();
        CodingErrorAction malformedInputAction = config.getMalformedInputAction() != null ? config.getMalformedInputAction() : CodingErrorAction.REPORT;
        CodingErrorAction codingErrorAction = unmappableInputAction = config.getUnmappableInputAction() != null ? config.getUnmappableInputAction() : CodingErrorAction.REPORT;
        if (charset != null) {
            chardecoder = charset.newDecoder();
            chardecoder.onMalformedInput(malformedInputAction);
            chardecoder.onUnmappableCharacter(unmappableInputAction);
            charencoder = charset.newEncoder();
            charencoder.onMalformedInput(malformedInputAction);
            charencoder.onUnmappableCharacter(unmappableInputAction);
        }
        ManagedNHttpClientConnectionImpl conn = new ManagedNHttpClientConnectionImpl(id, this.log, this.headerlog, this.wirelog, iosession, config.getBufferSize(), config.getFragmentSizeHint(), this.allocator, chardecoder, charencoder, config.getMessageConstraints(), null, null, this.requestWriterFactory, this.responseParserFactory);
        iosession.setAttribute("http.connection", conn);
        return conn;
    }
}

