/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.example;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import net.snowflake.ingest.internal.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngestExampleHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)IngestExampleHelper.class.getName());
    private static String ALGORITHM = "RSA";

    public static void makeLocalDirectory(String directoryPath) throws IOException {
        Files.createDirectories(Paths.get(directoryPath, new String[0]), new FileAttribute[0]);
    }

    public static Path createTempCsv(String directoryPath, String filename, int rows) throws IOException {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        Path csv = Files.createTempFile(Paths.get(directoryPath, new String[0]), filename, ".csv", new FileAttribute[0]);
        String fileName = csv.getFileName().toString();
        try (BufferedWriter w = Files.newBufferedWriter(csv, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (int i = 0; i < rows; ++i) {
                w.write(String.valueOf(i));
                w.write(",");
                w.write("row-");
                w.write(String.valueOf(i));
                w.write(",");
                w.write(String.valueOf(rnd.nextLong()));
                w.write(",");
                w.write(fileName);
                w.write("\n");
            }
        }
        return csv;
    }

    public static void makeSampleFile(String directoryPath, String filename) throws IOException {
        File file = new File(directoryPath, filename);
        if (!file.exists()) {
            file.createNewFile();
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            for (char letter = 'a'; letter <= 'z'; letter = (char)(letter + '\u0001')) {
                bw.write(letter + "\n");
            }
            bw.close();
        }
    }

    public static Connection getConnection(String user, String password, String account, String host, int port) throws Exception {
        Class.forName("net.snowflake.client.jdbc.SnowflakeDriver");
        Properties props = new Properties();
        props.put("user", user);
        props.put("password", password);
        props.put("account", account);
        props.put("ssl", "off");
        String connectString = "jdbc:snowflake://" + host + ":" + port;
        return DriverManager.getConnection(connectString, props);
    }

    public static void doQuery(Connection conn, String query) {
        LOGGER.info("doQuery {}", (Object)query);
        try (Statement statement = conn.createStatement();){
            statement.executeQuery(query);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static KeyPair generateKeyPair() throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM);
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        keyGen.initialize(2048, random);
        return keyGen.generateKeyPair();
    }

    public static String getPublicKeyString(KeyPair keypair) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PublicKey pk = keypair.getPublic();
        X509EncodedKeySpec spec = keyFactory.getKeySpec(pk, X509EncodedKeySpec.class);
        return Base64.encodeBase64String(spec.getEncoded());
    }
}

