/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.reports.model.CSSColor;
import net.serenitybdd.reports.model.ScenarioSummaryResult;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\r\u00a8\u0006\u001b"}, d2={"Lnet/serenitybdd/reports/model/ScenarioSummary;", "", "title", "", "testResult", "Lnet/thucydides/core/model/TestResult;", "reportName", "results", "", "Lnet/serenitybdd/reports/model/ScenarioSummaryResult;", "(Ljava/lang/String;Lnet/thucydides/core/model/TestResult;Ljava/lang/String;Ljava/util/List;)V", "color", "getColor", "()Ljava/lang/String;", "errorMessage", "getErrorMessage", "hasExamples", "", "getHasExamples", "()Z", "getReportName", "result", "getResult", "getResults", "()Ljava/util/List;", "getTitle", "Companion", "serenity-stats"})
public final class ScenarioSummary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String title;
    @NotNull
    private final String reportName;
    @NotNull
    private final List<ScenarioSummaryResult> results;
    @NotNull
    private final String result;
    @NotNull
    private final String color;
    @NotNull
    private final String errorMessage;
    private final boolean hasExamples;

    public ScenarioSummary(@NotNull String title, @NotNull TestResult testResult, @NotNull String reportName, @NotNull List<ScenarioSummaryResult> results) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)reportName, (String)"reportName");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        this.title = title;
        this.reportName = reportName;
        this.results = results;
        String string = testResult.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        this.result = string;
        this.color = new CSSColor().forResult(testResult);
        this.errorMessage = this.results.isEmpty() ? "" : this.results.get(0).getErrorMessage();
        this.hasExamples = this.results.size() > 1;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getReportName() {
        return this.reportName;
    }

    @NotNull
    public final List<ScenarioSummaryResult> getResults() {
        return this.results;
    }

    @NotNull
    public final String getResult() {
        return this.result;
    }

    @NotNull
    public final String getColor() {
        return this.color;
    }

    @NotNull
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final boolean getHasExamples() {
        return this.hasExamples;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lnet/serenitybdd/reports/model/ScenarioSummary$Companion;", "", "()V", "failingScenariosIn", "", "Lnet/serenitybdd/reports/model/ScenarioSummaryResult;", "outcome", "Lnet/thucydides/core/model/TestOutcome;", "from", "Lnet/serenitybdd/reports/model/ScenarioSummary;", "ofFailingScenariosIn", "serenity-stats"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScenarioSummary ofFailingScenariosIn(@NotNull TestOutcome outcome) {
            ScenarioSummary scenarioSummary;
            Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
            if (outcome.isDataDriven()) {
                String string = outcome.getTitle();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outcome.title");
                TestResult testResult = outcome.getResult();
                Intrinsics.checkNotNullExpressionValue((Object)testResult, (String)"outcome.result");
                String string2 = outcome.getHtmlReport();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outcome.htmlReport");
                scenarioSummary = new ScenarioSummary(string, testResult, string2, this.failingScenariosIn(outcome));
            } else {
                scenarioSummary = this.from(outcome);
            }
            return scenarioSummary;
        }

        /*
         * Unable to fully structure code
         */
        private final List<ScenarioSummaryResult> failingScenariosIn(TestOutcome outcome) {
            v0 = outcome.getTestSteps();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"outcome.testSteps");
            $this$filter$iv = v0;
            $i$f$filter = false;
            var4_4 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (TestStep)element$iv$iv;
                $i$a$-filter-ScenarioSummary$Companion$failingScenariosIn$1 = false;
                v1 = it.isCompromised();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.isCompromised");
                if (v1.booleanValue()) ** GOTO lbl-1000
                v2 = it.isFailure();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it.isFailure");
                if (v2.booleanValue()) ** GOTO lbl-1000
                v3 = it.isError();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it.isError");
                if (v3.booleanValue()) lbl-1000:
                // 3 sources

                {
                    v4 = true;
                } else {
                    v4 = false;
                }
                if (!v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (TestStep)item$iv$iv;
                var11_11 = destination$iv$iv;
                $i$a$-map-ScenarioSummary$Companion$failingScenariosIn$2 = false;
                v5 = it.getResult();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it.result");
                v6 = it.getConciseErrorMessage();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it.conciseErrorMessage");
                v7 = it.getDescription();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"it.description");
                v8 = it.getException();
                v9 = v8 != null ? v8.getErrorType() : null;
                if (v9 == null) {
                    v9 = "";
                }
                var11_11.add(new ScenarioSummaryResult(v5, v6, v7, v9));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final ScenarioSummary from(@NotNull TestOutcome outcome) {
            Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
            String string = outcome.getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outcome.title");
            TestResult testResult = outcome.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)testResult, (String)"outcome.result");
            String string2 = outcome.getHtmlReport();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outcome.htmlReport");
            TestResult testResult2 = outcome.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)testResult2, (String)"outcome.result");
            String string3 = outcome.getConciseErrorMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"outcome.conciseErrorMessage");
            String string4 = outcome.getDescription();
            if (string4 == null) {
                string4 = "";
            }
            String string5 = outcome.getTestFailureErrorType();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"outcome.testFailureErrorType");
            return new ScenarioSummary(string, testResult, string2, CollectionsKt.listOf((Object)new ScenarioSummaryResult(testResult2, string3, string4, string5)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

