/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.util;

import com.google.common.base.Splitter;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

class Acronym {
    private final String acronymText;
    private final int start;
    private final int end;

    Acronym(String acronym, int start, int end) {
        this.acronymText = acronym;
        this.start = start;
        this.end = end;
    }

    public static Set<Acronym> acronymsIn(String text) {
        HashSet<Acronym> acronyms = new HashSet<Acronym>();
        List words = Splitter.on((Pattern)Pattern.compile("\\W")).omitEmptyStrings().splitToList((CharSequence)text);
        for (String word : words) {
            if (!Acronym.isAnAcronym(word)) continue;
            acronyms.addAll(Acronym.appearencesOf(word, text));
        }
        return acronyms;
    }

    public String restoreIn(String text) {
        String prefix = this.start > 0 ? text.substring(0, this.start) : "";
        String suffix = text.substring(this.end, text.length());
        return prefix + this.acronymText + suffix;
    }

    private static Set<Acronym> appearencesOf(String word, String text) {
        int wordFoundAt;
        HashSet<Acronym> acronyms = new HashSet<Acronym>();
        for (int startAt = 0; startAt < text.length() && (wordFoundAt = text.indexOf(word, startAt)) != -1; startAt += word.length()) {
            acronyms.add(new Acronym(word, wordFoundAt, wordFoundAt + word.length()));
        }
        return acronyms;
    }

    public static boolean isAnAcronym(String word) {
        return word.length() > 1 && Character.isUpperCase(Acronym.firstLetterIn(word)) && Character.isUpperCase(Acronym.lastLetterIn(word));
    }

    private static char firstLetterIn(String word) {
        String wordWithoutDigits = word.replaceAll("\\d", "");
        return wordWithoutDigits.length() == 0 ? word.charAt(0) : wordWithoutDigits.charAt(0);
    }

    private static char lastLetterIn(String word) {
        String wordWithoutDigits = word.replaceAll("\\d", "");
        return wordWithoutDigits.length() == 0 ? word.charAt(word.length() - 1) : wordWithoutDigits.charAt(wordWithoutDigits.length() - 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Acronym acronym = (Acronym)o;
        return this.start == acronym.start && this.end == acronym.end && Objects.equals(this.acronymText, acronym.acronymText);
    }

    public int hashCode() {
        int result = this.acronymText != null ? this.acronymText.hashCode() : 0;
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Acronym{");
        sb.append("acronymText='").append(this.acronymText).append('\'');
        sb.append(", start=").append(this.start);
        sb.append(", end=").append(this.end);
        sb.append('}');
        return sb.toString();
    }
}

