/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.model.cucumber;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Scenario;
import java.util.Optional;
import java.util.stream.Collectors;
import net.thucydides.model.digest.Digest;
import net.thucydides.model.requirements.model.cucumber.ExampleTableInMarkdown;
import net.thucydides.model.requirements.model.cucumber.NamedScenario;
import net.thucydides.model.requirements.model.cucumber.ScenarioDisplayOption;
import net.thucydides.model.requirements.model.cucumber.ScenarioReport;
import net.thucydides.model.requirements.reports.cucumber.RenderCucumber;

public class IdentifiedScenario
extends NamedScenario {
    private final Feature feature;
    private final String scenarioId;
    private final Scenario scenarioDefinition;
    private final ExampleTableInMarkdown exampleTableInMarkdown;

    protected IdentifiedScenario(Feature feature, Scenario scenarioDefinition) {
        this.feature = feature;
        String scenarioReport = ScenarioReport.forScenario(scenarioDefinition.getName()).inFeature(feature);
        this.scenarioId = Digest.ofTextValue(scenarioDefinition.getName());
        this.scenarioDefinition = scenarioDefinition;
        this.exampleTableInMarkdown = new ExampleTableInMarkdown(feature, scenarioReport, scenarioDefinition.getName());
    }

    @Override
    public Optional<String> asGivenWhenThen() {
        return this.asGivenWhenThen(ScenarioDisplayOption.WithNoTitle);
    }

    @Override
    public Optional<String> asGivenWhenThen(ScenarioDisplayOption displayOption) {
        Object renderedDescription = "";
        String suffix = "";
        if (displayOption == ScenarioDisplayOption.WithTitle) {
            renderedDescription = "**" + this.scenarioDefinition.getName() + "**  " + this.resultToken() + System.lineSeparator();
        } else {
            suffix = this.resultToken();
        }
        renderedDescription = (String)renderedDescription + this.scenarioDefinition.getSteps().stream().map(step -> RenderCucumber.step(step) + "  ").collect(Collectors.joining(System.lineSeparator())) + suffix;
        renderedDescription = (String)renderedDescription + System.lineSeparator() + "[<i class=\"fa fa-info-circle\"></i> More details](#" + this.scenarioId + ")" + System.lineSeparator();
        return Optional.of((String)renderedDescription);
    }

    private String resultToken() {
        return "{result:" + this.feature.getName() + "!" + this.scenarioDefinition.getName() + "}";
    }

    @Override
    public Optional<String> asExampleTable() {
        return this.asExampleTable(ScenarioDisplayOption.WithNoTitle);
    }

    @Override
    public Optional<String> asExampleTable(ScenarioDisplayOption withDisplayOption) {
        if (this.scenarioDefinition.getExamples().isEmpty()) {
            return Optional.empty();
        }
        StringBuilder renderedExamples = new StringBuilder();
        int exampleRow = 0;
        for (Examples example : this.scenarioDefinition.getExamples()) {
            renderedExamples.append(this.exampleTableInMarkdown.renderedFormOf(example, exampleRow++, withDisplayOption));
            if (exampleRow >= this.scenarioDefinition.getExamples().size() - 1) continue;
            renderedExamples.append(System.lineSeparator());
        }
        return Optional.of(renderedExamples.toString());
    }
}

