/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.domain;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestTag;

public class TestTagCache {
    private static final Map<TestOutcomeTag, Boolean> MATCHING_TAGS = new ConcurrentHashMap<TestOutcomeTag, Boolean>();

    public static Optional<Boolean> hasMatchingTag(TestOutcome outcome, TestTag tag) {
        TestOutcomeTag testOutcomeTag = new TestOutcomeTag(outcome, tag);
        return Optional.ofNullable(MATCHING_TAGS.getOrDefault(testOutcomeTag, null));
    }

    public static void storeMatchingTagResult(TestOutcome outcome, TestTag tag, boolean matchFound) {
        TestOutcomeTag testOutcomeTag = new TestOutcomeTag(outcome, tag);
        MATCHING_TAGS.put(testOutcomeTag, matchFound);
    }

    public static void clear() {
        MATCHING_TAGS.clear();
    }

    private static class TestOutcomeTag {
        private final int testOutcome;
        private final TestTag testTag;

        private TestOutcomeTag(TestOutcome testOutcome, TestTag testTag) {
            this.testOutcome = testOutcome.hashCode();
            this.testTag = testTag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestOutcomeTag that = (TestOutcomeTag)o;
            if (this.testOutcome != that.testOutcome) {
                return false;
            }
            return Objects.equals(this.testTag, that.testTag);
        }

        public int hashCode() {
            int result = this.testOutcome;
            result = 31 * result + (this.testTag != null ? this.testTag.hashCode() : 0);
            return result;
        }
    }
}

