/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.model.history;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.serenitybdd.model.collect.NewMap;
import net.serenitybdd.model.history.ClearDirectoryContents;
import net.serenitybdd.model.history.LeaveDirectoryContents;
import net.serenitybdd.model.history.PrepareHistoryDirectory;
import net.serenitybdd.model.history.PreviousTestOutcome;
import net.serenitybdd.model.history.TestOutcomeSummaryRecorder;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.ReportNamer;
import net.thucydides.model.domain.ReportType;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.reports.AcceptanceTestLoader;
import net.thucydides.model.reports.json.JSONTestOutcomeReporter;
import net.thucydides.model.reports.json.gson.GsonPreviousOutcomeConverter;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemTestOutcomeSummaryRecorder
implements TestOutcomeSummaryRecorder {
    private final Path historyDirectory;
    private final Boolean deletePreviousHistory;
    private final AcceptanceTestLoader testOutcomeReporter = new JSONTestOutcomeReporter();
    private final GsonPreviousOutcomeConverter previousOutcomeConverter;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemTestOutcomeSummaryRecorder.class);
    private static final Map<Boolean, PrepareHistoryDirectory> DELETE_STRATEGY = NewMap.of(false, new LeaveDirectoryContents(), true, new ClearDirectoryContents());

    public FileSystemTestOutcomeSummaryRecorder(EnvironmentVariables environmentVariables) {
        this(Paths.get(ThucydidesSystemProperty.SERENITY_HISTORY_DIRECTORY.from(environmentVariables, "history"), ""), false);
    }

    public FileSystemTestOutcomeSummaryRecorder(Path historyDirectory, Boolean deletePreviousHistory) {
        this.historyDirectory = historyDirectory;
        this.deletePreviousHistory = Optional.ofNullable(deletePreviousHistory).orElse(false);
        this.previousOutcomeConverter = new GsonPreviousOutcomeConverter(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    @Override
    public void recordOutcomeSummariesFrom(Path sourceDirectory) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(sourceDirectory);){
            this.usingDeleteStrategyFor(this.deletePreviousHistory).prepareHistoryDirectory(this.historyDirectory);
            for (Path path : directoryStream) {
                this.storeOutcomesFrom(this.testOutcomeReporter.loadReportFrom(path).map(Collections::singleton).orElse(Collections.emptySet()));
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to store test outcome for posterity", (Throwable)ex);
        }
    }

    private void storeOutcomesFrom(Set<TestOutcome> testOutcomes) throws IOException {
        for (TestOutcome testOutcome : testOutcomes) {
            PreviousTestOutcome summary = PreviousTestOutcome.from(testOutcome);
            File summaryFile = this.summaryFileFor(testOutcome);
            Files.createDirectories(summaryFile.toPath().getParent(), new FileAttribute[0]);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(summaryFile));){
                this.previousOutcomeConverter.toJson(summary, outputStream);
                ((OutputStream)outputStream).flush();
            }
        }
    }

    @Override
    public List<PreviousTestOutcome> loadSummaries() {
        ArrayList<PreviousTestOutcome> previousTestOutcomes = new ArrayList<PreviousTestOutcome>();
        if (Files.exists(this.historyDirectory, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.historyDirectory);){
                for (Path path : directoryStream) {
                    this.previousTestOutcomesFrom(path).ifPresent(outcome -> previousTestOutcomes.add((PreviousTestOutcome)outcome));
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to store test outcome for posterity", (Throwable)ex);
            }
        }
        return previousTestOutcomes;
    }

    private Optional<PreviousTestOutcome> previousTestOutcomesFrom(Path source) {
        Optional<PreviousTestOutcome> optional;
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(source.toFile()));
        try {
            optional = this.previousOutcomeConverter.fromJson(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        ((InputStream)inputStream).close();
        return optional;
    }

    private PrepareHistoryDirectory usingDeleteStrategyFor(Boolean deletePreviousHistory) {
        return DELETE_STRATEGY.get(deletePreviousHistory);
    }

    private File summaryFileFor(TestOutcome testOutcome) {
        String summaryFilename = ReportNamer.forReportType(ReportType.JSON).withPrefix("summary-").getNormalizedReportNameFor(testOutcome);
        return this.historyDirectory.resolve(summaryFilename).toFile();
    }
}

