/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.xunit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.reports.adaptors.common.FilebasedOutcomeAdaptor;
import net.thucydides.core.reports.adaptors.xunit.BasicXUnitLoader;
import net.thucydides.core.reports.adaptors.xunit.XUnitLoader;
import net.thucydides.core.reports.adaptors.xunit.io.XUnitFiles;
import net.thucydides.core.reports.adaptors.xunit.model.TestCase;
import net.thucydides.core.reports.adaptors.xunit.model.TestException;
import net.thucydides.core.reports.adaptors.xunit.model.TestSuite;
import net.thucydides.core.util.NameConverter;

public class DefaultXUnitAdaptor
extends FilebasedOutcomeAdaptor {
    private final XUnitLoader loader = new BasicXUnitLoader();

    @Override
    public List<TestOutcome> loadOutcomesFrom(File source) throws IOException {
        ArrayList<TestOutcome> loadedOutcomes = new ArrayList<TestOutcome>();
        for (File xunitFile : XUnitFiles.in(source)) {
            loadedOutcomes.addAll(this.testOutcomesIn(xunitFile));
        }
        return NewList.copyOf(loadedOutcomes);
    }

    public List<TestOutcome> testOutcomesIn(File xunitFile) throws IOException {
        List<TestSuite> xunitTestSuites = this.loader.loadFrom(xunitFile);
        ArrayList<? extends TestOutcome> testOutcomes = new ArrayList<TestOutcome>();
        for (TestSuite testSuite : xunitTestSuites) {
            testOutcomes.addAll(this.testOutcomesIn(testSuite));
        }
        return NewList.copyOf(testOutcomes);
    }

    private Collection<? extends TestOutcome> testOutcomesIn(TestSuite testSuite) {
        return testSuite.getTestCases().stream().map(testCase -> this.convertToOutcome((TestCase)testCase)).collect(Collectors.toList());
    }

    private TestOutcome convertToOutcome(TestCase from) {
        TestOutcome outcome = TestOutcome.forTestInStory(from.getName(), Story.called(from.getClassname()));
        outcome.setTitle(NameConverter.humanize(from.getName()));
        outcome.setDuration(this.timeAsLong(from.getTime()));
        if (from.getError().isPresent()) {
            TestException failure = from.getError().get();
            outcome.determineTestFailureCause(failure.asException());
        } else if (from.getFailure().isPresent()) {
            TestException failure = from.getFailure().get();
            outcome.determineTestFailureCause(failure.asAssertionFailure());
        } else if (from.getSkipped().isPresent()) {
            outcome.setAnnotatedResult(TestResult.PENDING);
        } else {
            outcome.setAnnotatedResult(TestResult.SUCCESS);
        }
        return outcome;
    }

    private long timeAsLong(double time) {
        return time < 1.0 ? 1L : (long)time;
    }
}

