/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers.dates;

import java.util.Collection;
import java.util.Date;
import net.thucydides.core.matchers.dates.DateComparator;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class DateCollectionContainsSameDatesMatcher
extends TypeSafeMatcher<Collection<Date>> {
    private final Collection<Date> expectedDates;

    public DateCollectionContainsSameDatesMatcher(Collection<Date> expectedDates) {
        this.expectedDates = expectedDates;
    }

    public boolean matchesSafely(Collection<Date> dates) {
        if (dates.size() != this.expectedDates.size()) {
            return false;
        }
        for (Date expectedDate : this.expectedDates) {
            if (this.hasIdenticalDate(expectedDate, dates)) continue;
            return false;
        }
        return true;
    }

    private boolean hasIdenticalDate(Date expectedDate, Collection<Date> dates) {
        for (Date date : dates) {
            if (!DateComparator.sameDate(date, expectedDate)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a collection of dates containing ");
        description.appendValueList("[", ",", "]", this.expectedDates);
    }
}

