/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.configuration;

import java.io.File;
import java.nio.file.Paths;
import net.serenitybdd.core.strings.Joiner;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.configuration.MavenBuildDirectory;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class MavenOrGradleBuildPath {
    private final EnvironmentVariables environmentVariables;
    private static final String PROJECT_REPORTING_OUTPUT_DIRECTORY = "project.reporting.OutputDirectory";

    MavenOrGradleBuildPath(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static MavenOrGradleBuildPath specifiedIn(EnvironmentVariables environmentVariables) {
        return new MavenOrGradleBuildPath(environmentVariables);
    }

    public String getBuildDirectory() {
        if (StringUtils.isNotEmpty((CharSequence)this.projectOutputDirectory()) && this.isAbsolute(this.projectOutputDirectory())) {
            return MavenBuildDirectory.forAMavenProjectWithAConfiguredReportDirectory().buildDirectoryFrom(this.projectOutputDirectory());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.projectOutputDirectory())) {
            String baseDirectory = Joiner.on(File.separator).skipNulls().join(this.projectMavenBuildDirectory(), this.projectOutputDirectory());
            return MavenBuildDirectory.forAMavenProjectWithAConfiguredReportDirectory().buildDirectoryFrom(baseDirectory);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.projectMavenReportingDirectory())) {
            String baseDirectory = Joiner.on(File.separator).skipNulls().join(this.projectMavenBuildDirectory(), this.projectMavenReportingDirectory());
            return MavenBuildDirectory.forAMavenProjectWithAConfiguredReportDirectoryTarget().buildDirectoryFrom(baseDirectory);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.projectMavenBuildDirectory())) {
            return MavenBuildDirectory.forAMavenProject().buildDirectoryFrom(this.projectMavenBuildDirectory());
        }
        return MavenBuildDirectory.forADefaultMavenConfiguration().buildDirectoryFrom(this.projectMavenBuildDirectory());
    }

    private boolean isAbsolute(String path) {
        return Paths.get(path, new String[0]).isAbsolute();
    }

    private String projectMavenBuildDirectory() {
        return this.environmentVariables.getProperty("project.build.directory");
    }

    private String projectMavenReportingDirectory() {
        return this.environmentVariables.getProperty(PROJECT_REPORTING_OUTPUT_DIRECTORY);
    }

    private String projectOutputDirectory() {
        String thucydidesOutputDurectory = this.environmentVariables.getProperty(ThucydidesSystemProperty.THUCYDIDES_OUTPUT_DIRECTORY);
        String serenityOutputDurectory = this.environmentVariables.getProperty(ThucydidesSystemProperty.SERENITY_OUTPUT_DIRECTORY);
        return serenityOutputDurectory != null ? serenityOutputDurectory : thucydidesOutputDurectory;
    }

    public String getHistoryDirectory() {
        String serenityOutputDurectory = this.environmentVariables.getProperty(ThucydidesSystemProperty.SERENITY_HISTORY_DIRECTORY);
        return serenityOutputDurectory != null ? serenityOutputDurectory : "history";
    }

    public File resolve(File relativeDirectory) {
        if (StringUtils.isEmpty((CharSequence)this.projectMavenBuildDirectory())) {
            return relativeDirectory;
        }
        return Paths.get(this.projectMavenBuildDirectory(), new String[0]).resolve(relativeDirectory.toPath()).toFile();
    }
}

