/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.files;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class TheDirectoryStructure {
    private final File rootDirectory;

    public TheDirectoryStructure(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public static TheDirectoryStructure startingAt(File rootDirectory) {
        return new TheDirectoryStructure(rootDirectory);
    }

    public boolean containsFiles(FileFilter ... fileFilters) {
        for (File file : this.nestedFilesIn(this.rootDirectory)) {
            for (FileFilter fileFilter : fileFilters) {
                if (!fileFilter.accept(file)) continue;
                return true;
            }
        }
        return false;
    }

    private List<File> nestedFilesIn(File directory) {
        if (!directory.isDirectory()) {
            return new ArrayList<File>();
        }
        ArrayList<File> nestedFiles = new ArrayList<File>();
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                nestedFiles.addAll(this.nestedFilesIn(file));
                continue;
            }
            nestedFiles.add(file);
        }
        return nestedFiles;
    }

    public int maxDepth() {
        if (!this.rootDirectory.isDirectory()) {
            return 0;
        }
        Collection directoryContents = FileUtils.listFilesAndDirs((File)this.rootDirectory, (IOFileFilter)new NotFileFilter(TrueFileFilter.INSTANCE), (IOFileFilter)this.normalDirectoriesOnly());
        int maxDepth = 0;
        for (File file : directoryContents) {
            String relativePath = file.getPath().replace(this.rootDirectory.getPath(), "");
            int depth = Splitter.on((String)File.separator).trimResults().splitToList((CharSequence)relativePath).size() - 1;
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth;
    }

    private IOFileFilter normalDirectoriesOnly() {
        return new IOFileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && !file.getName().startsWith(".");
            }

            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory() && !name.startsWith(".");
            }
        };
    }
}

