/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import java.math.BigDecimal;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TestScenarioResult {
    public final String feature;
    public final String scenario;
    public final BigDecimal duration;
    public final String scenarioKey;

    public static TestScenarioResult createFromCSV(CSVRecord csvRecord) {
        return new TestScenarioResult(csvRecord.get("Story"), csvRecord.get("Title"), new BigDecimal(csvRecord.get("Duration (s)")));
    }

    public BigDecimal duration() {
        return this.duration;
    }

    public TestScenarioResult(String feature, String scenario, BigDecimal duration) {
        this.feature = feature;
        this.scenario = scenario;
        this.scenarioKey = feature + ":" + scenario;
        this.duration = duration;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

