/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import net.serenitybdd.core.di.SerenityInfrastructure;
import net.serenitybdd.core.webdriver.driverproviders.DownloadableDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.EnhanceCapabilitiesWithFixtures;
import net.serenitybdd.core.webdriver.driverproviders.UpdateDriverEnvironmentProperty;
import net.serenitybdd.model.buildinfo.DriverCapabilityRecord;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.TestContext;
import net.thucydides.core.webdriver.capabilities.W3CCapabilities;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import net.thucydides.model.util.EnvironmentVariables;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;

public class InternetExplorerDriverProvider
extends DownloadableDriverProvider
implements DriverProvider {
    private final DriverCapabilityRecord driverProperties;
    private final FixtureProviderService fixtureProviderService;

    public InternetExplorerDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = SerenityInfrastructure.getDriverCapabilityRecord();
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getParallelEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        UpdateDriverEnvironmentProperty.forDriverProperty("webdriver.ie.driver");
        InternetExplorerOptions ieOptions = W3CCapabilities.definedIn(environmentVariables).withPrefix("webdriver.capabilities").internetExplorerOptions();
        EnhanceCapabilitiesWithFixtures.using(this.fixtureProviderService).into((MutableCapabilities)ieOptions);
        TestContext.forTheCurrentTest().recordBrowserConfiguration((Capabilities)ieOptions);
        TestContext.forTheCurrentTest().recordCurrentPlatform();
        this.driverProperties.registerCapabilities("ie", this.capabilitiesToProperties((Capabilities)ieOptions));
        return new InternetExplorerDriver(ieOptions);
    }
}

