/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.Optional;
import net.serenitybdd.core.di.SerenityInfrastructure;
import net.serenitybdd.core.webdriver.driverproviders.DriverExecutableIsDefined;
import net.serenitybdd.model.CurrentOS;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.model.util.EnvironmentVariables;

public class UpdateDriverEnvironmentProperty {
    public static void forDriverProperty(String driverProperty) {
        if (!DriverExecutableIsDefined.bySystemProperty(driverProperty)) {
            EnvironmentVariables environmentVariables = SerenityInfrastructure.getEnvironmentVariables();
            Optional defaultConfiguredDriver = environmentVariables.optionalProperty(driverProperty);
            String osSpecificDriverProperty = UpdateDriverEnvironmentProperty.osSpecific(driverProperty);
            Optional optionalDriverPath = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{osSpecificDriverProperty});
            String resolvedDriverProperty = defaultConfiguredDriver.orElse(optionalDriverPath.orElse(null));
            if (resolvedDriverProperty != null) {
                System.setProperty(driverProperty, resolvedDriverProperty);
            }
        }
    }

    private static String osSpecific(String exeProperty) {
        return "drivers." + String.valueOf(CurrentOS.getType()) + "." + exeProperty;
    }
}

