/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.net.MalformedURLException;
import java.net.URL;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.RemoteDriverBuilder;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.WebDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;

class DefaultRemoteDriver
extends RemoteDriverBuilder {
    private final DriverCapabilities remoteDriverCapabilities;

    DefaultRemoteDriver(EnvironmentVariables environmentVariables, DriverCapabilities remoteDriverCapabilities) {
        super(environmentVariables);
        this.remoteDriverCapabilities = remoteDriverCapabilities;
    }

    @Override
    WebDriver buildWithOptions(String options) throws MalformedURLException {
        String remoteUrl = ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.from(this.environmentVariables);
        Capabilities capabilities = this.buildRemoteCapabilities(options);
        return this.newRemoteDriver(new URL(remoteUrl), capabilities, options);
    }

    private Capabilities buildRemoteCapabilities(String options) {
        String driver = ThucydidesSystemProperty.WEBDRIVER_REMOTE_DRIVER.from(this.environmentVariables);
        if (driver == null) {
            driver = WebDriverFactory.getDriverFrom(this.environmentVariables);
        }
        return this.remoteDriverCapabilities.forDriver(driver, options);
    }
}

