/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.appium;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.webdriver.appium.NoAvailableDeviceException;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppiumDevicePool {
    private final int DEFAULT_APPIUM_PORT = 4273;
    Logger LOGGER = LoggerFactory.getLogger(AppiumDevicePool.class);
    private final List<String> deviceList;
    private final List<String> availableDevices;
    private final Map<String, Integer> ports = new HashMap<String, Integer>();
    private static AppiumDevicePool pool;

    public static synchronized AppiumDevicePool instance(EnvironmentVariables environmentVariables) {
        if (pool == null) {
            pool = new AppiumDevicePool(environmentVariables);
        }
        return pool;
    }

    public static synchronized AppiumDevicePool instance() {
        return AppiumDevicePool.instance((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public boolean hasMultipleDevices() {
        return this.deviceList.size() > 1;
    }

    public boolean hasOnlyOneDevice() {
        return this.deviceList.size() == 1;
    }

    public static void clear() {
        pool = null;
    }

    public AppiumDevicePool(EnvironmentVariables environmentVariables) {
        List<String> specifiedDevices = this.elementsIn(ThucydidesSystemProperty.APPIUM_DEVICE_NAMES.from(environmentVariables, ""));
        String definedDevice = ThucydidesSystemProperty.APPIUM_DEVICE_NAME.from(environmentVariables);
        if (specifiedDevices.isEmpty()) {
            this.deviceList = this.deviceListFromSingleDevice(definedDevice);
            this.ports.put(definedDevice, 4273);
        } else {
            this.deviceList = this.elementsIn(ThucydidesSystemProperty.APPIUM_DEVICE_NAMES.from(environmentVariables, ""));
        }
        this.availableDevices = Collections.synchronizedList(new ArrayList<String>(this.deviceList));
        this.LOGGER.info("Appium Device Pool initialised with devices: " + this.deviceList);
    }

    private List<String> deviceListFromSingleDevice(String definedDevice) {
        return definedDevice == null ? new ArrayList() : Collections.singletonList(definedDevice);
    }

    public List<String> getAvailableDevices() {
        return new ArrayList<String>(this.availableDevices);
    }

    private List<String> elementsIn(String list) {
        return Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)list);
    }

    public synchronized void freeDevice(String deviceName) {
        this.LOGGER.info("Device freed: " + deviceName);
        this.availableDevices.add(deviceName);
    }

    public synchronized String requestDevice() {
        if (this.availableDevices.isEmpty()) {
            throw new NoAvailableDeviceException("No available Appium device found - have you specified a device in appium.deviceName or a list of available devices in appium.deviceNames?");
        }
        String providedDevice = this.availableDevices.remove(0);
        this.LOGGER.info("Device provided: " + providedDevice);
        this.LOGGER.info("Remaining devices: " + this.availableDevices);
        return providedDevice;
    }

    public int portFor(String deviceName) {
        return this.ports.getOrDefault(deviceName, 4273);
    }
}

