/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.domestic.reduction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConcurrentCollectors {
    private ConcurrentCollectors() {
    }

    @NotNull
    public static <T> Collector<T, ?, List<T>> toConcurrentList() {
        return Collector.of(() -> Collections.synchronizedList(new ArrayList()), List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collector.Characteristics.CONCURRENT);
    }

    @NotNull
    public static <T> Collector<T, ?, Set<T>> toConcurrentSet() {
        return Collectors.collectingAndThen(Collectors.toConcurrentMap(Function.identity(), t -> Boolean.TRUE, ConcurrentCollectors.retainingMerger()), Map::keySet);
    }

    public static <T> Collector<T, ?, T> reducingConcurrent(T identity, @NotNull BinaryOperator<T> op) {
        ObjectUtils.requireNonNull(op);
        return Collector.of(() -> new AtomicReference<Object>(identity), (ar, e) -> ar.accumulateAndGet(e, op), (t1, t2) -> {
            t1.accumulateAndGet(t2.get(), op);
            return t1;
        }, AtomicReference::get, Collector.Characteristics.CONCURRENT);
    }

    @NotNull
    public static <T> Collector<T, ?, Optional<T>> reducingConcurrent(@NotNull BinaryOperator<T> op) {
        ObjectUtils.requireNonNull(op);
        BinaryOperator internalAccumulator = (a, b) -> {
            if (a == null) {
                return b;
            }
            return op.apply(a, b);
        };
        return Collector.of(AtomicReference::new, (ar, e) -> ar.accumulateAndGet(e, internalAccumulator), (t1, t2) -> {
            t1.accumulateAndGet(t2.get(), internalAccumulator);
            return t1;
        }, ar -> Optional.ofNullable(ar.get()), Collector.Characteristics.CONCURRENT);
    }

    @NotNull
    public static <T, R> Collector<T, ?, R> reducingConcurrent(@Nullable R identity, @NotNull Function<? super T, ? extends R> mapper, @NotNull BinaryOperator<R> op) {
        ObjectUtils.requireNonNull(mapper);
        ObjectUtils.requireNonNull(op);
        return Collector.of(() -> new AtomicReference<Object>(identity), (ar, t) -> ar.accumulateAndGet(mapper.apply(t), op), (t1, t2) -> {
            t1.accumulateAndGet(t2.get(), op);
            return t1;
        }, AtomicReference::get, Collector.Characteristics.CONCURRENT);
    }

    public static <V> BinaryOperator<V> replacingMerger() {
        return (u, v) -> v;
    }

    public static <V> BinaryOperator<V> retainingMerger() {
        return (u, v) -> u;
    }

    public static <V> BinaryOperator<V> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate value for %s", u));
        };
    }
}

