/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.BinaryMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface MarshallableOut {
    @NotNull
    default public DocumentContext writingDocument() throws UnrecoverableTimeoutException {
        return this.writingDocument(false);
    }

    public DocumentContext writingDocument(boolean var1) throws UnrecoverableTimeoutException;

    default public boolean recordHistory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void writeMessage(WireKey key, Object value) throws UnrecoverableTimeoutException {
        try (DocumentContext dc = this.writingDocument();){
            Wire wire = dc.wire();
            wire.write(key).object(value);
        }
    }

    default public void writeDocument(@NotNull WriteMarshallable writer) throws UnrecoverableTimeoutException {
        try (DocumentContext dc = this.writingDocument(false);){
            Wire wire = dc.wire();
            writer.writeMarshallable(wire);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void writeBytes(@NotNull WriteBytesMarshallable marshallable) throws UnrecoverableTimeoutException {
        try (DocumentContext dc = this.writingDocument();){
            marshallable.writeMarshallable(dc.wire().bytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> void writeDocument(T t, @NotNull BiConsumer<ValueOut, T> writer) throws UnrecoverableTimeoutException {
        try (DocumentContext dc = this.writingDocument();){
            Wire wire = dc.wire();
            writer.accept(wire.getValueOut(), (ValueOut)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void writeText(@NotNull CharSequence text) throws UnrecoverableTimeoutException {
        try (DocumentContext dc = this.writingDocument();){
            dc.wire().getValueOut().text(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void writeMap(@NotNull Map<?, ?> map) throws UnrecoverableTimeoutException {
        try (DocumentContext dc = this.writingDocument();){
            Wire wire = dc.wire();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                wire.writeEvent(Object.class, entry.getKey()).object(Object.class, entry.getValue());
            }
        }
    }

    @NotNull
    default public <T> T methodWriter(@NotNull Class<T> tClass, Class ... additional) {
        return this.methodWriter(false, tClass, additional);
    }

    @NotNull
    default public <T> T methodWriter(boolean metaData, @NotNull Class<T> tClass, Class ... additional) {
        Class[] interfaces = (Class[])ObjectUtils.addAll(tClass, (Object[])additional);
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), interfaces, (InvocationHandler)((Object)new BinaryMethodWriterInvocationHandler(metaData, this)));
    }

    @NotNull
    default public <T> VanillaMethodWriterBuilder<T> methodWriterBuilder(@NotNull Class<T> tClass) {
        return new VanillaMethodWriterBuilder<T>(tClass, new BinaryMethodWriterInvocationHandler(false, this));
    }

    @NotNull
    default public Padding padToCacheAlignMode() {
        return Padding.NEVER;
    }

    public static enum Padding {
        WORD("align to every word"),
        CACHE_LINE("always pads to cache lines"),
        NEVER("never adds padding"),
        SMART("adds padding to ensure new wire headers dont straggle cache lines, where possible to do so without breaking theexisting message format specification");

        @Deprecated
        public static final Padding ALWAYS;

        private Padding(String comment) {
        }

        static {
            ALWAYS = CACHE_LINE;
        }
    }
}

