/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.watcher;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.watcher.WatcherListener;

public class FileSystemWatcher {
    private final WatchService watchService;
    private final Map<WatchKey, PathInfo> watchKeyToPathMap = new ConcurrentHashMap<WatchKey, PathInfo>();
    private final Set<WatchKey> watchKeysToRemove = new CopyOnWriteArraySet<WatchKey>();
    private final BlockingQueue<WatcherListener> listenersToAdd = new LinkedBlockingQueue<WatcherListener>();
    private volatile boolean running = true;
    private final List<WatcherListener> listeners = new ArrayList<WatcherListener>();
    private final Thread thread = new Thread(this::run, "watcher");

    public FileSystemWatcher() throws IOException {
        this.watchService = FileSystems.getDefault().newWatchService();
    }

    private static String p(String path) {
        return OS.isWindows() ? path.replace('\\', '/') : path;
    }

    public void addPath(String directory) {
        this.addPath(directory, "");
    }

    public void addPath(final String base, String relative) {
        final Path base0 = Paths.get(base, new String[0]);
        Path base2 = base0.resolve(relative);
        if (Files.isDirectory(base2, new LinkOption[0])) {
            try {
                Files.walkFileTree(base2, Collections.singleton(FileVisitOption.FOLLOW_LINKS), 8, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return this.visitFile(dir, attrs);
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        FileSystemWatcher.this.addPath0(base0, file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        FileSystemWatcher.this.warnOnException(exc, base);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        FileSystemWatcher.this.warnOnException(exc, base);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                this.warnOnException(e, base);
            }
            try {
                this.bootstrapPath(this.listeners, base, relative);
            }
            catch (IOException e) {
                this.warnOnException(e, base);
            }
        }
    }

    void addPath0(Path base, Path full) {
        if (Files.isDirectory(full, new LinkOption[0])) {
            try {
                String basePath = base.toString();
                this.watchKeyToPathMap.put(full.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY), new PathInfo(basePath, full.toString()));
            }
            catch (IOException e) {
                Jvm.warn().on(FileSystemWatcher.class, "Couldn't add path " + full, e);
            }
        }
    }

    public void addListener(WatcherListener listener) {
        this.listenersToAdd.add(listener);
        this.thread.interrupt();
    }

    private void removePath(String filename) {
        this.watchKeyToPathMap.keySet().stream().filter(k -> this.matches(this.watchKeyToPathMap.get(k), filename)).forEach(wk -> {
            this.watchKeysToRemove.add((WatchKey)wk);
            wk.cancel();
        });
    }

    private boolean matches(PathInfo path, String filename) {
        String s = path.full;
        return s.equals(filename) || s.startsWith(filename + "/");
    }

    void run() {
        while (this.running) {
            ArrayList<WatcherListener> list = new ArrayList<WatcherListener>();
            this.listenersToAdd.drainTo(list);
            this.bootstrap(list);
            this.listeners.addAll(list);
            try {
                WatchKey key = this.watchService.take();
                if (key == null) break;
                PathInfo base = this.watchKeyToPathMap.get(key);
                for (WatchEvent<?> event : key.pollEvents()) {
                    Iterator<WatcherListener> iterator = this.listeners.iterator();
                    while (iterator.hasNext()) {
                        WatcherListener listener = iterator.next();
                        try {
                            if (event.kind() == StandardWatchEventKinds.OVERFLOW) {
                                Jvm.warn().on(this.getClass(), "Overflow on watcher events for " + base);
                                this.bootstrap(this.listeners);
                                continue;
                            }
                            WatchEvent<?> event2 = event;
                            String fullRelative = (base.relativePath.isEmpty() ? "" : base.relativePath + "/") + event2.context();
                            String filename = base.basePath + "/" + fullRelative;
                            if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                                listener.onExists(FileSystemWatcher.p(base.basePath), FileSystemWatcher.p(fullRelative), false);
                                this.addPath(base.basePath, fullRelative);
                                continue;
                            }
                            if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                                listener.onExists(FileSystemWatcher.p(base.basePath), FileSystemWatcher.p(fullRelative), true);
                                continue;
                            }
                            if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                            listener.onRemoved(FileSystemWatcher.p(base.basePath), FileSystemWatcher.p(fullRelative));
                            this.removePath(filename);
                        }
                        catch (IllegalStateException ise) {
                            iterator.remove();
                        }
                    }
                }
                key.reset();
                if (!this.watchKeysToRemove.contains(key)) continue;
                this.watchKeyToPathMap.remove(key);
                this.watchKeysToRemove.remove(key);
            }
            catch (InterruptedException expected) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void bootstrap(List<WatcherListener> list) {
        for (PathInfo pathInfo : this.watchKeyToPathMap.values()) {
            try {
                this.bootstrapPath(list, pathInfo.basePath, "");
            }
            catch (IOException e) {
                Jvm.warn().on(this.getClass(), "Failed to walk " + pathInfo, e);
            }
        }
    }

    private void bootstrapPath(final List<WatcherListener> list, final String base, String relative) throws IOException {
        final Path full = Paths.get(base, new String[0]).resolve(relative);
        Files.walkFileTree(full, Collections.singleton(FileVisitOption.FOLLOW_LINKS), 8, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return this.visitFile(dir, attrs);
            }

            @Override
            public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) throws IOException {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    WatcherListener listener = (WatcherListener)iterator.next();
                    String pToString = p.toString();
                    if (pToString.equals(full.toString())) continue;
                    String filename = pToString.substring(base.length() + 1);
                    try {
                        listener.onExists(FileSystemWatcher.p(base), FileSystemWatcher.p(filename), null);
                    }
                    catch (IllegalStateException ise) {
                        iterator.remove();
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                FileSystemWatcher.this.warnOnException(exc, base);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                FileSystemWatcher.this.warnOnException(exc, base);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        this.running = false;
        this.thread.interrupt();
        try {
            this.thread.join(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Closeable.closeQuietly((Object)this.watchService);
    }

    private void warnOnException(IOException exc, String base) {
        if (exc != null) {
            Jvm.warn().on(FileSystemWatcher.class, "Couldn't walk path " + base, exc);
        }
    }

    static class PathInfo {
        final String basePath;
        final String full;
        final String relativePath;

        public PathInfo(String basePath, String full) {
            this.basePath = basePath;
            this.full = full;
            this.relativePath = basePath.equals(full) ? "" : full.substring(basePath.length() + 1);
        }
    }
}

