/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.threads.VanillaEventHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timer {
    static final Logger LOG = LoggerFactory.getLogger(Timer.class);
    private final EventLoop eventLoop;

    public Timer(@NotNull EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public void scheduleAtFixedRate(@NotNull VanillaEventHandler eventHandler, long initialDelayMs, long periodMs) {
        this.eventLoop.addHandler(new ScheduledEventHandler(eventHandler, initialDelayMs, periodMs));
    }

    public void schedule(VanillaEventHandler eventHandler, long periodMs) {
        this.eventLoop.addHandler(new ScheduledEventHandler(eventHandler, 0L, periodMs));
    }

    private class ScheduledEventHandler
    implements EventHandler {
        private final VanillaEventHandler eventHandler;
        private final long initialDelayMs;
        private final long periodMs;
        private boolean isFirstTime = true;
        private long lastTimeRan = System.currentTimeMillis();

        private ScheduledEventHandler(VanillaEventHandler eventHandler, long initialDelayMs, long periodMs) {
            this.initialDelayMs = initialDelayMs;
            this.periodMs = periodMs;
            this.eventHandler = eventHandler;
        }

        @Override
        public boolean action() throws InvalidEventHandlerException, InterruptedException {
            long currentTime = System.currentTimeMillis();
            if (this.lastTimeRan + this.waitTimeMs() > currentTime) {
                return false;
            }
            this.lastTimeRan = currentTime;
            try {
                return this.eventHandler.action();
            }
            catch (RuntimeException e) {
                Jvm.warn().on(this.getClass(), "Unexpected runtime exception", e);
                return false;
            }
        }

        private long waitTimeMs() {
            if (!this.isFirstTime) {
                return this.periodMs;
            }
            this.isFirstTime = false;
            return this.initialDelayMs;
        }

        @Override
        @NotNull
        public HandlerPriority priority() {
            return HandlerPriority.TIMER;
        }
    }
}

