/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.reducers;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.reducers.ElementComparator;
import net.masterthought.cucumber.reducers.ReducingMethod;
import net.masterthought.cucumber.reducers.ReportFeatureMerger;

final class ReportFeatureWithRetestMerger
implements ReportFeatureMerger {
    private static final String ERROR = "You are not able to use this type of results merge. The start_timestamp field should be part of element object. Please, update the cucumber-jvm version.";
    private static final ElementComparator ELEMENT_COMPARATOR = new ElementComparator();

    ReportFeatureWithRetestMerger() {
    }

    @Override
    public List<Feature> merge(List<Feature> features) {
        HashMap<String, Feature> mergedFeatures = new HashMap<String, Feature>();
        for (Feature candidate : features) {
            Feature mergedFeature = (Feature)mergedFeatures.get(candidate.getId());
            if (mergedFeature == null) {
                mergedFeatures.put(candidate.getId(), candidate);
                continue;
            }
            this.updateElements((Feature)mergedFeatures.get(candidate.getId()), candidate.getElements());
        }
        return new ArrayList<Feature>(mergedFeatures.values());
    }

    void updateElements(Feature feature, Element[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            Element current = elements[i];
            if (!current.isScenario()) continue;
            Preconditions.checkArgument((current.getStartTime() != null ? 1 : 0) != 0, (Object)ERROR);
            int indexOfPreviousResult = this.find(feature.getElements(), current);
            boolean hasBackground = this.isBackground(i - 1, elements);
            if (indexOfPreviousResult < 0) {
                Element[] elementArray;
                if (hasBackground) {
                    Element[] elementArray2 = new Element[2];
                    elementArray2[0] = elements[i - 1];
                    elementArray = elementArray2;
                    elementArray2[1] = current;
                } else {
                    Element[] elementArray3 = new Element[1];
                    elementArray = elementArray3;
                    elementArray3[0] = current;
                }
                feature.addElements(elementArray);
                continue;
            }
            if (!this.replaceIfExists(feature.getElements()[indexOfPreviousResult], current)) continue;
            feature.getElements()[indexOfPreviousResult] = current;
            if (!hasBackground || !this.isBackground(indexOfPreviousResult - 1, feature.getElements())) continue;
            feature.getElements()[indexOfPreviousResult - 1] = elements[i - 1];
        }
    }

    boolean replaceIfExists(Element target, Element candidate) {
        return candidate.getStartTime().compareTo(target.getStartTime()) >= 0;
    }

    boolean isBackground(int elementInd, Element[] elements) {
        return elementInd >= 0 && elements != null && elementInd < elements.length && elements[elementInd].isBackground();
    }

    int find(Element[] elements, Element target) {
        for (int i = 0; i < elements.length; ++i) {
            if (ELEMENT_COMPARATOR.compare(elements[i], target) != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean test(List<ReducingMethod> reducingMethods) {
        return reducingMethods != null && reducingMethods.contains((Object)ReducingMethod.MERGE_FEATURES_WITH_RETEST);
    }
}

