/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.decorate;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.logstash.logback.decorate.Decorator;

public class CompositeDecorator<T, D extends Decorator<T>>
implements Decorator<T> {
    private final List<D> decorators = new CopyOnWriteArrayList<D>();

    @Override
    public T decorate(T decoratable) {
        T decorated = decoratable;
        for (Decorator decorator : this.decorators) {
            decorated = decorator.decorate(decorated);
        }
        return decorated;
    }

    public void addDecorator(D decorator) {
        this.decorators.add(decorator);
    }

    public boolean removeDecorator(D decorator) {
        return this.decorators.remove(decorator);
    }
}

