/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.List;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.loggingevent.LogstashMarkersJsonProvider;
import net.logstash.logback.fieldnames.LogstashFieldNames;
import org.slf4j.Marker;
import tools.jackson.core.JsonGenerator;

public class TagsJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    public static final String FIELD_TAGS = "tags";

    public TagsJsonProvider() {
        this.setFieldName(FIELD_TAGS);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) {
        boolean hasWrittenStart = false;
        if (hasWrittenStart = this.writeTagIfNecessary(generator, hasWrittenStart, event.getMarkerList())) {
            generator.writeEndArray();
        }
    }

    private boolean writeTagIfNecessary(JsonGenerator generator, boolean hasWrittenStart, List<Marker> markers) {
        if (markers != null) {
            for (Marker marker : markers) {
                hasWrittenStart |= this.writeTagIfNecessary(generator, hasWrittenStart, marker);
            }
        }
        return hasWrittenStart;
    }

    private boolean writeTagIfNecessary(JsonGenerator generator, boolean hasWrittenStart, Marker marker) {
        if (marker != null) {
            if (!LogstashMarkersJsonProvider.isLogstashMarker(marker)) {
                if (!hasWrittenStart) {
                    generator.writeArrayPropertyStart(this.getFieldName());
                    hasWrittenStart = true;
                }
                generator.writeString(marker.getName());
            }
            if (marker.hasReferences()) {
                for (Marker next : marker) {
                    hasWrittenStart |= this.writeTagIfNecessary(generator, hasWrittenStart, next);
                }
            }
        }
        return hasWrittenStart;
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getTags());
    }
}

