/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import java.util.Map;
import tools.jackson.core.JsonGenerator;

public class JsonWritingUtils {
    public static void writeMapEntries(JsonGenerator generator, Map<?, ?> map) {
        if (map != null) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                generator.writePOJOProperty(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public static void writeMapStringFields(JsonGenerator generator, String fieldName, Map<String, String> map) {
        JsonWritingUtils.writeMapStringFields(generator, fieldName, map, false);
    }

    public static void writeMapStringFields(JsonGenerator generator, String fieldName, Map<String, String> map, boolean lowerCaseKeys) {
        if (JsonWritingUtils.shouldWriteField(fieldName) && map != null && !map.isEmpty()) {
            generator.writeObjectPropertyStart(fieldName);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey() != null && lowerCaseKeys ? entry.getKey().toLowerCase() : entry.getKey();
                JsonWritingUtils.writeStringField(generator, key, entry.getValue());
            }
            generator.writeEndObject();
        }
    }

    public static void writeStringArrayField(JsonGenerator generator, String fieldName, String[] fieldValues) {
        if (JsonWritingUtils.shouldWriteField(fieldName) && fieldValues != null && fieldValues.length > 0) {
            generator.writeArrayPropertyStart(fieldName);
            for (String fieldValue : fieldValues) {
                generator.writeString(fieldValue);
            }
            generator.writeEndArray();
        }
    }

    public static void writeStringField(JsonGenerator generator, String fieldName, String fieldValue) {
        if (JsonWritingUtils.shouldWriteField(fieldName) && fieldValue != null) {
            generator.writeStringProperty(fieldName, fieldValue);
        }
    }

    public static void writeNumberField(JsonGenerator generator, String fieldName, int fieldValue) {
        if (JsonWritingUtils.shouldWriteField(fieldName)) {
            generator.writeNumberProperty(fieldName, fieldValue);
        }
    }

    public static void writeNumberField(JsonGenerator generator, String fieldName, long fieldValue) {
        if (JsonWritingUtils.shouldWriteField(fieldName)) {
            generator.writeNumberProperty(fieldName, fieldValue);
        }
    }

    public static boolean shouldWriteField(String fieldName) {
        return fieldName != null && !fieldName.equals("[ignore]");
    }
}

