/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.security.Key;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Vector;
import net.jsign.jca.AbstractKeyStoreSpi;
import net.jsign.jca.SigningService;

class SigningServiceKeyStore
extends AbstractKeyStoreSpi {
    private final SigningService service;

    public SigningServiceKeyStore(SigningService service) {
        this.service = service;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws UnrecoverableKeyException {
        return this.service.getPrivateKey(alias, password);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] chain = null;
        try {
            chain = this.service.getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            SigningServiceKeyStore.rethrow(e);
        }
        return chain;
    }

    @Override
    public Enumeration<String> engineAliases() {
        Enumeration<String> aliases = null;
        try {
            aliases = new Vector<String>(this.service.aliases()).elements();
        }
        catch (KeyStoreException e) {
            SigningServiceKeyStore.rethrow(e);
        }
        return aliases;
    }

    private static <T extends Throwable> void rethrow(Throwable t) throws T {
        throw t;
    }
}

