/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import com.cedarsoftware.util.io.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

class RESTClient {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final String endpoint;
    private BiConsumer<HttpURLConnection, byte[]> authenticationHandler;
    private Function<Map<String, ?>, String> errorHandler;

    public RESTClient(String endpoint) {
        this.endpoint = endpoint;
    }

    public RESTClient authentication(Consumer<HttpURLConnection> authenticationHeaderSupplier) {
        this.authenticationHandler = (conn, data) -> authenticationHeaderSupplier.accept((HttpURLConnection)conn);
        return this;
    }

    public RESTClient authentication(BiConsumer<HttpURLConnection, byte[]> authenticationHeaderSupplier) {
        this.authenticationHandler = authenticationHeaderSupplier;
        return this;
    }

    public RESTClient errorHandler(Function<Map<String, ?>, String> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public Map<String, ?> get(String resource) throws IOException {
        return this.query("GET", resource, null, null);
    }

    public Map<String, ?> post(String resource, String body) throws IOException {
        return this.query("POST", resource, body, null);
    }

    public Map<String, ?> post(String resource, String body, Map<String, String> headers) throws IOException {
        return this.query("POST", resource, body, headers);
    }

    public Map<String, ?> post(String resource, Map<String, String> params) throws IOException {
        return this.post(resource, params, false);
    }

    public Map<String, ?> post(String resource, Map<String, ?> params, boolean multipart) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        StringBuilder body = new StringBuilder();
        if (multipart) {
            String boundary = "------------------------" + Long.toHexString(new Random().nextLong());
            headers.put("Content-Type", "multipart/form-data; boundary=" + boundary);
            for (String name : params.keySet()) {
                Object value = params.get(name);
                body.append("--" + boundary + "\r\n");
                if (value instanceof byte[]) {
                    body.append("Content-Type: application/octet-stream\r\n");
                    body.append("Content-Disposition: form-data; name=\"" + name + '\"' + "; filename=\"" + name + ".data\"\r\n");
                    body.append("\r\n");
                    body.append(new String((byte[])value, StandardCharsets.UTF_8));
                } else {
                    body.append("Content-Disposition: form-data; name=\"" + name + '\"' + "\r\n");
                    body.append("\r\n");
                    body.append(params.get(name));
                }
                body.append("\r\n");
            }
            body.append("--" + boundary + "--");
        } else {
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            for (Map.Entry<String, ?> param : params.entrySet()) {
                if (body.length() > 0) {
                    body.append('&');
                }
                body.append(param.getKey()).append('=').append(URLEncoder.encode(param.getValue().toString(), "UTF-8"));
            }
        }
        return this.post(resource, body.toString(), headers);
    }

    private Map<String, ?> query(String method, String resource, String body, Map<String, String> headers) throws IOException {
        String error;
        byte[] data;
        URL url = new URL(resource.startsWith("http") ? resource : this.endpoint + resource);
        this.log.finest(method + " " + url);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        String userAgent = System.getProperty("http.agent");
        conn.setRequestProperty("User-Agent", "Jsign (https://ebourg.github.io/jsign/)" + (userAgent != null ? " " + userAgent : ""));
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        byte[] byArray = data = body != null ? body.getBytes(StandardCharsets.UTF_8) : null;
        if (this.authenticationHandler != null) {
            this.authenticationHandler.accept(conn, data);
        }
        if (body != null) {
            if (!conn.getRequestProperties().containsKey("Content-Type")) {
                conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            }
            conn.setRequestProperty("Content-Length", String.valueOf(data.length));
        }
        if (this.log.isLoggable(Level.FINEST)) {
            for (String requestHeader : conn.getRequestProperties().keySet()) {
                List<String> values = conn.getRequestProperties().get(requestHeader);
                this.log.finest(requestHeader + ": " + (values.size() == 1 ? values.get(0) : values));
            }
        }
        if (body != null) {
            this.log.finest("Content:\n" + body);
            conn.setDoOutput(true);
            conn.getOutputStream().write(data);
        }
        this.log.finest("");
        int n = conn.getResponseCode();
        String contentType = conn.getHeaderField("Content-Type");
        this.log.finest("Response Code: " + n);
        this.log.finest("Content-Type: " + contentType);
        if (n < 400) {
            byte[] binaryResponse = IOUtils.toByteArray((InputStream)conn.getInputStream());
            String response = new String(binaryResponse, StandardCharsets.UTF_8);
            this.log.finest("Content-Length: " + binaryResponse.length);
            this.log.finest("Content:\n" + response);
            this.log.finest("");
            Object value = JsonReader.jsonToJava((String)response);
            if (value instanceof Map) {
                return (Map)value;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("result", value);
            return map;
        }
        String string = error = conn.getErrorStream() != null ? IOUtils.toString((InputStream)conn.getErrorStream(), (Charset)StandardCharsets.UTF_8) : "";
        if (conn.getErrorStream() != null) {
            this.log.finest("Error:\n" + error);
        }
        if (contentType != null && (contentType.startsWith("application/json") || contentType.startsWith("application/x-amz-json-1.1"))) {
            throw new IOException(this.errorHandler != null ? this.errorHandler.apply(JsonReader.jsonToMaps((String)error)) : error);
        }
        throw new IOException("HTTP Error " + n + (conn.getResponseMessage() != null ? " - " + conn.getResponseMessage() : "") + " (" + url + ")");
    }
}

