/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import net.jsign.zip.ZipRecord;

class Zip64EndOfCentralDirectoryLocator
extends ZipRecord {
    public static final int SIGNATURE = 117853008;
    public static final int SIZE = 20;
    public int numberOfTheDiskWithTheStartOfTheZip64EndOfCentralDirectory;
    public long zip64EndOfCentralDirectoryRecordOffset;
    public int numberOfDisks = 1;

    Zip64EndOfCentralDirectoryLocator() {
    }

    @Override
    public void read(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(buffer);
        buffer.flip();
        int signature = buffer.getInt();
        if (signature != 117853008) {
            throw new IOException("Invalid ZIP64 End of Central Directory Locator signature " + String.format("0x%04x", (long)signature & 0xFFFFFFFFL));
        }
        this.numberOfTheDiskWithTheStartOfTheZip64EndOfCentralDirectory = buffer.getInt();
        this.zip64EndOfCentralDirectoryRecordOffset = buffer.getLong();
        this.numberOfDisks = buffer.getInt();
    }

    @Override
    public ByteBuffer toBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(117853008);
        buffer.putInt(this.numberOfTheDiskWithTheStartOfTheZip64EndOfCentralDirectory);
        buffer.putLong(this.zip64EndOfCentralDirectoryRecordOffset);
        buffer.putInt(this.numberOfDisks);
        buffer.flip();
        return buffer;
    }
}

