/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jsign.zip.ExtraField;
import net.jsign.zip.Zip64ExtendedInfoExtraField;
import net.jsign.zip.ZipRecord;

public class CentralDirectoryFileHeader
extends ZipRecord {
    public static final int SIGNATURE = 33639248;
    private static final int MIN_SIZE = 46;
    public int versionMadeBy;
    public int versionNeededToExtract;
    public int generalPurposeBitFlag;
    public int compressionMethod;
    public int lastModFileTime;
    public int lastModFileDate;
    public int crc32;
    public long compressedSize;
    public long uncompressedSize;
    public int diskNumberStart;
    public int internalFileAttributes;
    public int externalFileAttributes;
    public long localHeaderOffset;
    public byte[] fileName = new byte[0];
    public byte[] fileComment = new byte[0];
    public Map<Integer, ExtraField> extraFields = new LinkedHashMap<Integer, ExtraField>();

    @Override
    public void read(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(46).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(buffer);
        buffer.flip();
        if (buffer.remaining() < 46) {
            throw new IOException("Invalid Central Directory File Header");
        }
        int signature = buffer.getInt();
        if (signature != 33639248) {
            throw new IOException("Invalid Central Directory File Header signature " + String.format("0x%04x", (long)signature & 0xFFFFFFFFL));
        }
        this.versionMadeBy = buffer.getShort();
        this.versionNeededToExtract = buffer.getShort();
        this.generalPurposeBitFlag = buffer.getShort();
        this.compressionMethod = buffer.getShort();
        this.lastModFileTime = buffer.getShort();
        this.lastModFileDate = buffer.getShort();
        this.crc32 = buffer.getInt();
        this.compressedSize = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.uncompressedSize = (long)buffer.getInt() & 0xFFFFFFFFL;
        int fileNameLength = buffer.getShort() & 0xFFFF;
        int extraFieldsLength = buffer.getShort() & 0xFFFF;
        int fileCommentLength = buffer.getShort() & 0xFFFF;
        this.diskNumberStart = buffer.getShort();
        this.internalFileAttributes = buffer.getShort();
        this.externalFileAttributes = buffer.getInt();
        this.localHeaderOffset = (long)buffer.getInt() & 0xFFFFFFFFL;
        if (fileNameLength > 0) {
            this.fileName = new byte[fileNameLength];
            channel.read(ByteBuffer.wrap(this.fileName));
        }
        if (extraFieldsLength > 0) {
            byte[] extraFields = new byte[extraFieldsLength];
            channel.read(ByteBuffer.wrap(extraFields));
            this.extraFields = ExtraField.parseAll(ByteBuffer.wrap(extraFields).order(ByteOrder.LITTLE_ENDIAN), this.uncompressedSize == 0xFFFFFFFFL, this.compressedSize == 0xFFFFFFFFL, this.localHeaderOffset == 0xFFFFFFFFL, this.diskNumberStart == 65535);
        }
        if (fileCommentLength > 0) {
            this.fileComment = new byte[fileCommentLength];
            channel.read(ByteBuffer.wrap(this.fileComment));
        }
        if (!(this.extraFields.containsKey(1) || this.localHeaderOffset != 0xFFFFFFFFL && this.compressedSize != 0xFFFFFFFFL && this.uncompressedSize != 0xFFFFFFFFL)) {
            throw new IOException("Missing ZIP64 extra field in the Central Directory File Header");
        }
    }

    private int getExtraFieldsLength() {
        int length = 0;
        for (ExtraField field : this.extraFields.values()) {
            length += field.size();
        }
        return length;
    }

    @Override
    public ByteBuffer toBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(46 + this.fileName.length + this.getExtraFieldsLength() + this.fileComment.length).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(33639248);
        buffer.putShort((short)this.versionMadeBy);
        buffer.putShort((short)this.versionNeededToExtract);
        buffer.putShort((short)this.generalPurposeBitFlag);
        buffer.putShort((short)this.compressionMethod);
        buffer.putShort((short)this.lastModFileTime);
        buffer.putShort((short)this.lastModFileDate);
        buffer.putInt(this.crc32);
        buffer.putInt((int)this.compressedSize);
        buffer.putInt((int)this.uncompressedSize);
        buffer.putShort((short)this.fileName.length);
        buffer.putShort((short)this.getExtraFieldsLength());
        buffer.putShort((short)this.fileComment.length);
        buffer.putShort((short)this.diskNumberStart);
        buffer.putShort((short)this.internalFileAttributes);
        buffer.putInt(this.externalFileAttributes);
        buffer.putInt((int)this.localHeaderOffset);
        buffer.put(this.fileName);
        if (!this.extraFields.isEmpty()) {
            for (ExtraField field : this.extraFields.values()) {
                field.write(buffer);
            }
        }
        buffer.put(this.fileComment);
        buffer.flip();
        return buffer;
    }

    public long getCompressedSize() {
        if (this.compressedSize == 0xFFFFFFFFL) {
            Zip64ExtendedInfoExtraField zip64ExtraField = (Zip64ExtendedInfoExtraField)this.extraFields.get(1);
            return zip64ExtraField.compressedSize;
        }
        return this.compressedSize;
    }

    public long getUncompressedSize() {
        if (this.uncompressedSize == 0xFFFFFFFFL) {
            Zip64ExtendedInfoExtraField zip64ExtraField = (Zip64ExtendedInfoExtraField)this.extraFields.get(1);
            return zip64ExtraField.uncompressedSize;
        }
        return this.uncompressedSize;
    }

    public long getLocalHeaderOffset() {
        if (this.localHeaderOffset == 0xFFFFFFFFL) {
            Zip64ExtendedInfoExtraField zip64ExtraField = (Zip64ExtendedInfoExtraField)this.extraFields.get(1);
            return zip64ExtraField.localHeaderOffset;
        }
        return this.localHeaderOffset;
    }

    public void setLocalHeaderOffset(long offset) {
        if (offset > 0xFFFFFFFFL || this.localHeaderOffset == 0xFFFFFFFFL) {
            Zip64ExtendedInfoExtraField zip64ExtraField = (Zip64ExtendedInfoExtraField)this.extraFields.get(1);
            zip64ExtraField.localHeaderOffset = offset;
            this.localHeaderOffset = 0xFFFFFFFFL;
        } else {
            this.localHeaderOffset = offset;
        }
    }
}

