/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.http.server.servlet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.xml.transform.Source;
import net.javacrumbs.smock.common.InterceptingTemplate;
import net.javacrumbs.smock.common.XmlUtil;
import net.javacrumbs.smock.common.server.MockWebServiceClientResponseActions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.DefaultMessageContext;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.test.server.RequestCreator;
import org.springframework.ws.test.server.ResponseActions;
import org.springframework.ws.transport.WebServiceMessageReceiver;

public class CommonServletBasedMockWebServiceClient {
    private static final String CONTENT_TYPE = "text/xml;charset=UTF-8";
    private final HttpServlet servlet;
    private final WebServiceMessageFactory messageFactory;
    private final InterceptingTemplate interceptingTemplate;
    private static final Log LOG = LogFactory.getLog(CommonServletBasedMockWebServiceClient.class);

    public CommonServletBasedMockWebServiceClient(HttpServlet servlet, WebServiceMessageFactory messageFactory, ClientInterceptor[] clientInterceptors) {
        Assert.notNull((Object)servlet, (String)"servlet has to be set");
        Assert.notNull((Object)messageFactory, (String)"messageFactory has to be set");
        this.messageFactory = messageFactory;
        this.servlet = servlet;
        this.interceptingTemplate = new InterceptingTemplate(clientInterceptors);
    }

    public ResponseActions sendRequestTo(String path, RequestCreator requestCreator) {
        try {
            Assert.notNull((Object)requestCreator, (String)"'requestCreator' must not be null");
            WebServiceMessage requestMessage = requestCreator.createRequest(this.messageFactory);
            final MockHttpServletRequest request = this.createRequest(path, requestMessage);
            DefaultMessageContext messageContext = new DefaultMessageContext(requestMessage, this.messageFactory);
            this.interceptingTemplate.interceptRequest((MessageContext)messageContext, new WebServiceMessageReceiver(){

                public void receive(MessageContext messageContext) throws Exception {
                    ExtendedMockHttpServletResponse response = new ExtendedMockHttpServletResponse();
                    CommonServletBasedMockWebServiceClient.this.servlet.service((ServletRequest)request, (ServletResponse)response);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Received response:" + response.getContentAsString()));
                    }
                    messageContext.setResponse(CommonServletBasedMockWebServiceClient.this.messageFactory.createWebServiceMessage((InputStream)new ByteArrayInputStream(response.getContentAsByteArray())));
                }
            });
            return new MockWebServiceClientResponseActions((MessageContext)messageContext);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error when sending request", e);
        }
    }

    protected MockHttpServletRequest createRequest(String path, WebServiceMessage message) {
        String requestXml = XmlUtil.serialize((Source)XmlUtil.getEnvelopeSource((WebServiceMessage)message));
        ExtendedMockHttpServletRequest request = new ExtendedMockHttpServletRequest();
        request.setMethod("POST");
        request.setPathInfo(path);
        request.setRequestURI(path);
        request.setContent(XmlUtil.stringToBytes((String)requestXml));
        request.setContentType(CONTENT_TYPE);
        request.addHeader("Content-Type", CONTENT_TYPE);
        return request;
    }

    private static class ExtendedMockHttpServletResponse
    extends MockHttpServletResponse {
        private ExtendedMockHttpServletResponse() {
        }

        public String getContentAsString() throws UnsupportedEncodingException {
            if (this.getCharacterEncoding() != null) {
                return new String(this.getContentAsByteArray(), this.getCharacterEncoding().toUpperCase().replaceAll("\"", ""));
            }
            return new String(this.getContentAsByteArray());
        }
    }

    private static class ExtendedMockHttpServletRequest
    extends MockHttpServletRequest {
        private ExtendedMockHttpServletRequest() {
        }

        public String getRealPath(String path) {
            return super.getPathInfo();
        }
    }
}

