/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.servletcontainer;

import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLException;
import javax.servlet.http.HttpServletRequest;

public interface TlsRenegotiationRequestor {
    public boolean isNeedClientAuth();

    public boolean isRequestSupportsTlsRenegotiation();

    public void requestTlsRenegotiation(Boolean var1, long var2, TimeUnit var4) throws SSLException, TimeoutException;

    public static boolean isWantingTlsRenegotiation(HttpServletRequest req, Boolean wantClientAuth, boolean force) {
        if (force) {
            return true;
        }
        if (wantClientAuth == null) {
            return false;
        }
        if (wantClientAuth.booleanValue()) {
            return TlsRenegotiationRequestor.extractCertificate(req) == null;
        }
        return TlsRenegotiationRequestor.extractCertificate(req) != null;
    }

    public static X509Certificate extractCertificate(HttpServletRequest request) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (null != certs && certs.length > 0) {
            return certs[0];
        }
        return null;
    }
}

