/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.AndDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.FilteringDependencyNodeVisitor;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;
import scala_maven.BasicArtifact;
import scala_maven.MavenArtifactResolver;
import scala_maven.VersionNumber;
import scala_maven.VersionNumberMask;
import scala_maven_dependency.ArtifactIds;
import scala_maven_dependency.ArtifactIds4Scala2;
import scala_maven_dependency.ArtifactIds4Scala3;
import scala_maven_dependency.CheckScalaVersionVisitor;
import scala_maven_dependency.Context;
import scala_maven_dependency.Context4ScalaHome;
import scala_maven_dependency.Context4ScalaRemote;
import scala_maven_dependency.ScalaDistroArtifactFilter;
import scala_maven_executions.JavaMainCaller;
import scala_maven_executions.JavaMainCallerByFork;
import scala_maven_executions.JavaMainCallerInProcess;
import scala_maven_executions.JavaMainCallerSupport;
import util.FileUtils;

public abstract class ScalaMojoSupport
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    protected MavenSession session;
    @Component
    RepositorySystem factory;
    @Parameter
    protected BasicArtifact[] dependencies;
    @Parameter
    private BasicArtifact[] compilerPlugins;
    @Parameter
    protected String[] jvmArgs;
    @Parameter
    protected String[] args;
    @Parameter(property="addScalacArgs")
    private String addScalacArgs;
    @Parameter(required=true, property="maven.scala.className", defaultValue="scala.tools.nsc.Main")
    protected String scalaClassName;
    @Parameter(property="scala.version")
    private String scalaVersion;
    @Parameter(property="scala.organization", defaultValue="org.scala-lang")
    private String scalaOrganization;
    @Parameter(property="scala.compat.version")
    private String scalaCompatVersion;
    @Parameter(property="scala.home")
    private String scalaHome;
    @Parameter(property="javacArgs")
    protected String[] javacArgs;
    @Parameter(property="javacGenerateDebugSymbols", defaultValue="true")
    protected boolean javacGenerateDebugSymbols = true;
    @Parameter(property="addJavacArgs")
    protected String addJavacArgs;
    @Parameter(property="maven.compiler.source")
    protected String source;
    @Parameter(property="maven.compiler.target")
    protected String target;
    @Parameter(property="project.build.sourceEncoding", defaultValue="UTF-8")
    protected String encoding;
    @Parameter(property="displayCmd", defaultValue="false", required=true)
    public boolean displayCmd;
    @Parameter(defaultValue="true")
    protected boolean fork = true;
    @Parameter(defaultValue="false")
    protected boolean forceUseArgFile = false;
    @Parameter(property="maven.scala.checkConsistency", defaultValue="true")
    protected boolean checkMultipleScalaVersions;
    @Parameter(defaultValue="false")
    protected boolean failOnMultipleScalaVersions = false;
    @Parameter(property="maven.scala.useCanonicalPath", defaultValue="true")
    protected boolean useCanonicalPath = true;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    protected ToolchainManager toolchainManager;
    @Parameter(defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginArtifacts;
    private MavenArtifactResolver mavenArtifactResolver;
    private Context scalaContext;

    public MavenArtifactResolver findMavenArtifactResolver() {
        if (this.mavenArtifactResolver == null) {
            this.mavenArtifactResolver = new MavenArtifactResolver(this.factory, this.session);
        }
        return this.mavenArtifactResolver;
    }

    public Context findScalaContext() throws Exception {
        if (this.scalaContext == null) {
            VersionNumber requiredScalaVersion;
            VersionNumber scalaVersion = this.findScalaVersion();
            ArtifactIds aids = scalaVersion.major == 3 ? new ArtifactIds4Scala3(scalaVersion) : new ArtifactIds4Scala2();
            VersionNumber versionNumber = requiredScalaVersion = StringUtils.isNotEmpty((String)this.scalaCompatVersion) ? new VersionNumberMask(this.scalaCompatVersion) : scalaVersion;
            if (requiredScalaVersion.compareTo(scalaVersion) != 0) {
                String msg = String.format("Scala library detected %s doesn't match scala.compat.version : %s", scalaVersion, requiredScalaVersion);
                if (this.failOnMultipleScalaVersions) {
                    this.getLog().error((CharSequence)msg);
                    throw new MojoFailureException(msg);
                }
                this.getLog().warn((CharSequence)msg);
            }
            this.scalaContext = StringUtils.isNotEmpty((String)this.scalaHome) ? new Context4ScalaHome(scalaVersion, requiredScalaVersion, aids, new File(this.scalaHome)) : new Context4ScalaRemote(scalaVersion, requiredScalaVersion, aids, this.scalaOrganization, this.findMavenArtifactResolver());
        }
        return this.scalaContext;
    }

    protected void addToClasspath(String groupId, String artifactId, String version, String classifier, Set<File> classpath, boolean addDependencies) throws Exception {
        MavenArtifactResolver mar = this.findMavenArtifactResolver();
        if (addDependencies) {
            for (Artifact a : mar.getJarAndDependencies(groupId, artifactId, version, classifier)) {
                classpath.add(a.getFile());
            }
        } else {
            Artifact a = mar.getJar(groupId, artifactId, version, classifier);
            classpath.add(a.getFile());
        }
    }

    void addCompilerToClasspath(Set<File> classpath) throws Exception {
        Context sc = this.findScalaContext();
        for (Artifact dep : sc.findCompilerAndDependencies()) {
            classpath.add(dep.getFile());
        }
    }

    void addLibraryToClasspath(Set<File> classpath) throws Exception {
        Context sc = this.findScalaContext();
        for (Artifact dep : sc.findLibraryAndDependencies()) {
            classpath.add(dep.getFile());
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String oldWay = System.getProperty("maven.scala.version");
            if (oldWay != null) {
                this.getLog().warn((CharSequence)"using 'maven.scala.version' is deprecated, use 'scala.version' instead");
                if (this.scalaVersion != null) {
                    this.scalaVersion = oldWay;
                }
            }
            if ((oldWay = System.getProperty("maven.scala.displayCmd")) != null) {
                this.getLog().warn((CharSequence)"using 'maven.scala.displayCmd' is deprecated, use 'displayCmd' instead");
                this.displayCmd = this.displayCmd || Boolean.parseBoolean(oldWay);
            }
            this.checkScalaVersion();
            this.doExecute();
        }
        catch (MojoExecutionException exc) {
            throw exc;
        }
        catch (RuntimeException | MojoFailureException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException("wrap: " + exc, exc);
        }
    }

    protected List<Dependency> getDependencies() {
        return this.project.getCompileDependencies();
    }

    private VersionNumber findScalaVersion() throws Exception {
        String detectedScalaVersion = this.scalaVersion;
        if (StringUtils.isEmpty((String)detectedScalaVersion)) {
            detectedScalaVersion = this.findVersionFromDependencies(this.scalaOrganization, ArtifactIds.SCALA_LIBRARY_PATTERN);
        }
        if (StringUtils.isEmpty((String)detectedScalaVersion)) {
            if (!"pom".equals(this.project.getPackaging())) {
                String error = String.format("%s:%s is missing from project dependencies", this.scalaOrganization, ArtifactIds.SCALA_LIBRARY_PATTERN.pattern());
                this.getLog().error((CharSequence)error);
                throw new UnsupportedOperationException(error);
            }
        } else {
            boolean isSnapshot = ArtifactUtils.isSnapshot((String)detectedScalaVersion);
            if (isSnapshot && !detectedScalaVersion.endsWith("-SNAPSHOT")) {
                detectedScalaVersion = detectedScalaVersion.substring(0, detectedScalaVersion.lastIndexOf(45, detectedScalaVersion.lastIndexOf(45) - 1)) + "-SNAPSHOT";
            }
        }
        if (StringUtils.isEmpty((String)detectedScalaVersion)) {
            throw new MojoFailureException("no scalaVersion detected or set");
        }
        if (StringUtils.isNotEmpty((String)this.scalaVersion) && !this.scalaVersion.equals(detectedScalaVersion)) {
            this.getLog().warn((CharSequence)"scala library version define in dependencies doesn't match the scalaVersion of the plugin");
        }
        return new VersionNumber(detectedScalaVersion);
    }

    private String findVersionFromDependencies(String groupId, Pattern artifactId) {
        VersionNumber version = new VersionNumber("0.0.0");
        for (Dependency dep : this.getDependencies()) {
            if (!groupId.equals(dep.getGroupId()) || !artifactId.matcher(dep.getArtifactId()).find()) continue;
            version = version.max(new VersionNumber(dep.getVersion()));
        }
        if (version.major == 0) {
            ArrayList deps = new ArrayList();
            deps.addAll(this.project.getModel().getDependencies());
            if (this.project.getModel().getDependencyManagement() != null) {
                deps.addAll(this.project.getModel().getDependencyManagement().getDependencies());
            }
            for (Dependency dep : deps) {
                if (!groupId.equals(dep.getGroupId()) || !artifactId.matcher(dep.getArtifactId()).find()) continue;
                version = version.max(new VersionNumber(dep.getVersion()));
            }
        }
        return version.major == 0 ? null : version.toString();
    }

    void checkScalaVersion() throws Exception {
        String sv = this.findScalaVersion().toString();
        if (StringUtils.isNotEmpty((String)this.scalaHome)) {
            this.getLog().warn((CharSequence)String.format("local scala-library.jar and scala-compiler.jar from scalaHome(%s) used instead of scala %s", this.scalaHome, sv));
        }
        if (this.checkMultipleScalaVersions) {
            this.checkCorrectVersionsOfScalaLibrary(sv);
        }
    }

    private void checkCorrectVersionsOfScalaLibrary(String scalaDefVersion) throws Exception {
        VersionNumber requiredScalaVersion;
        this.getLog().debug((CharSequence)"Checking for multiple versions of scala");
        VersionNumber sv = new VersionNumber(scalaDefVersion);
        VersionNumber versionNumber = requiredScalaVersion = StringUtils.isNotEmpty((String)this.scalaCompatVersion) ? new VersionNumberMask(this.scalaCompatVersion) : sv;
        if (requiredScalaVersion.compareTo(sv) != 0) {
            String msg = String.format("Scala library detected %s doesn't match scala.compat.version : %s", sv, requiredScalaVersion);
            if (this.failOnMultipleScalaVersions) {
                this.getLog().error((CharSequence)msg);
                throw new MojoFailureException(msg);
            }
            this.getLog().warn((CharSequence)msg);
        }
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        request.setProject(this.project);
        this.checkArtifactForScalaVersion(this.findScalaContext(), this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)request, null));
    }

    private void checkArtifactForScalaVersion(Context scalaContext, DependencyNode rootNode) throws Exception {
        CheckScalaVersionVisitor visitor = new CheckScalaVersionVisitor(scalaContext, this.getLog());
        CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
        FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collectingVisitor, this.createScalaDistroDependencyFilter());
        rootNode.accept((DependencyNodeVisitor)firstPassVisitor);
        AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
        FilteringDependencyNodeVisitor filteredVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)visitor, (DependencyNodeFilter)secondPassFilter);
        rootNode.accept((DependencyNodeVisitor)filteredVisitor);
        if (visitor.isFailed()) {
            visitor.logScalaDependents();
            if (this.failOnMultipleScalaVersions) {
                this.getLog().error((CharSequence)"Multiple versions of scala libraries detected!");
                throw new MojoFailureException("Multiple versions of scala libraries detected!");
            }
            this.getLog().warn((CharSequence)"Multiple versions of scala libraries detected!");
        }
    }

    private DependencyNodeFilter createScalaDistroDependencyFilter() throws Exception {
        ArrayList<ScalaDistroArtifactFilter> filters = new ArrayList<ScalaDistroArtifactFilter>();
        filters.add(new ScalaDistroArtifactFilter(this.findScalaContext()));
        return new AndDependencyNodeFilter(filters);
    }

    protected abstract void doExecute() throws Exception;

    protected JavaMainCaller getScalaCommand() throws Exception {
        return this.getScalaCommand(this.fork, this.scalaClassName);
    }

    final JavaMainCaller getScalaCommand(boolean forkOverride, String mainClass) throws Exception {
        JavaMainCaller cmd = this.getEmptyScalaCommand(mainClass, forkOverride);
        cmd.addArgs(this.args);
        if (StringUtils.isNotEmpty((String)this.addScalacArgs)) {
            cmd.addArgs(StringUtils.split((String)this.addScalacArgs, (String)"|"));
        }
        this.addCompilerPluginOptions(cmd);
        cmd.addJvmArgs(this.jvmArgs);
        return cmd;
    }

    final JavaMainCaller getEmptyScalaCommand(String mainClass) throws Exception {
        return this.getEmptyScalaCommand(mainClass, this.fork);
    }

    private JavaMainCaller getEmptyScalaCommand(String mainClass, boolean forkOverride) throws Exception {
        JavaMainCallerSupport cmd;
        if (forkOverride != this.fork) {
            super.getLog().info((CharSequence)"Fork behavior overridden");
            super.getLog().info((CharSequence)String.format("Fork for this execution is %s.", String.valueOf(forkOverride)));
        }
        String toolcp = this.getToolClasspath();
        if (forkOverride) {
            boolean bootcp = true;
            if (this.args != null) {
                for (String arg : this.args) {
                    bootcp = bootcp && !"-nobootcp".equals(arg);
                }
            }
            String cp = bootcp ? "" : toolcp;
            bootcp = bootcp && (!StringUtils.isNotEmpty((String)this.addScalacArgs) || !this.addScalacArgs.contains("-nobootcp"));
            this.getLog().debug((CharSequence)("use java command with args in file forced : " + this.forceUseArgFile));
            cmd = new JavaMainCallerByFork(this, mainClass, cp, null, null, this.forceUseArgFile, this.getToolchain());
            if (bootcp) {
                cmd.addJvmArgs("-Xbootclasspath/a:" + toolcp);
            }
        } else {
            cmd = new JavaMainCallerInProcess(this, mainClass, toolcp, null, null);
        }
        return cmd;
    }

    protected Toolchain getToolchain() {
        return this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
    }

    private String getToolClasspath() throws Exception {
        TreeSet<File> classpath = new TreeSet<File>();
        this.addLibraryToClasspath(classpath);
        this.addCompilerToClasspath(classpath);
        if (this.dependencies != null) {
            for (BasicArtifact artifact : this.dependencies) {
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, "", classpath, true);
            }
        }
        return FileUtils.toMultiPath(classpath);
    }

    protected List<String> getScalaOptions() throws Exception {
        ArrayList<String> options = new ArrayList<String>();
        if (this.args != null) {
            Collections.addAll(options, this.args);
        }
        if (StringUtils.isNotEmpty((String)this.addScalacArgs)) {
            Collections.addAll(options, StringUtils.split((String)this.addScalacArgs, (String)"|"));
        }
        options.addAll(this.getCompilerPluginOptions());
        return options;
    }

    protected List<String> getJavacOptions() {
        ArrayList<String> options = new ArrayList<String>();
        if (this.javacArgs != null) {
            Collections.addAll(options, this.javacArgs);
        }
        if (StringUtils.isNotEmpty((String)this.addJavacArgs)) {
            Collections.addAll(options, StringUtils.split((String)this.addJavacArgs, (String)"|"));
        }
        if (this.javacGenerateDebugSymbols) {
            options.add("-g");
        }
        if (this.target != null && !this.target.isEmpty()) {
            options.add("-target");
            options.add(this.target);
        }
        if (this.source != null && !this.source.isEmpty()) {
            options.add("-source");
            options.add(this.source);
        }
        if (this.encoding != null) {
            options.add("-encoding");
            options.add(this.encoding);
        }
        return options;
    }

    protected boolean isJavaSupportedByCompiler() throws Exception {
        return this.findScalaVersion().compareTo(new VersionNumber("2.7.2")) >= 0;
    }

    protected void addCompilerPluginOptions(JavaMainCaller scalac) throws Exception {
        for (String option : this.getCompilerPluginOptions()) {
            scalac.addArgs(option);
        }
    }

    private List<String> getCompilerPluginOptions() throws Exception {
        ArrayList<String> options = new ArrayList<String>();
        for (File plugin : this.getCompilerPlugins()) {
            options.add("-Xplugin:" + plugin.getPath());
        }
        return options;
    }

    private Set<File> getCompilerPlugins() throws Exception {
        TreeSet<File> plugins = new TreeSet<File>();
        if (this.compilerPlugins != null) {
            TreeSet<File> ignoreClasspath = new TreeSet<File>();
            this.addCompilerToClasspath(ignoreClasspath);
            this.addLibraryToClasspath(ignoreClasspath);
            for (BasicArtifact artifact : this.compilerPlugins) {
                this.getLog().info((CharSequence)("compiler plugin: " + artifact.toString()));
                TreeSet<File> pluginClassPath = new TreeSet<File>();
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, artifact.classifier, pluginClassPath, false);
                pluginClassPath.removeAll(ignoreClasspath);
                plugins.addAll(pluginClassPath);
            }
        }
        return plugins;
    }
}

