/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import scala_maven.ScalaMojoSupport;
import scala_maven.VersionNumber;
import scala_maven_executions.JavaMainCaller;
import util.FileUtils;

@Mojo(name="console", requiresDependencyResolution=ResolutionScope.TEST, inheritByDefault=false, requiresDirectInvocation=true)
public class ScalaConsoleMojo
extends ScalaMojoSupport {
    private static final String JLINE = "jline";
    private static final String SCALA_ORG_GROUP = "org.scala-lang";
    @Parameter(property="mainConsole", defaultValue="scala.tools.nsc.MainGenericRunner", required=true)
    private String mainConsole;
    @Parameter(property="maven.scala.console.useTestClasspath", defaultValue="true", required=true)
    private boolean useTestClasspath;
    @Parameter(property="maven.scala.console.useRuntimeClasspath", defaultValue="true", required=true)
    private boolean useRuntimeClasspath;
    @Parameter(property="javarebel.jar.path")
    private File javaRebelPath;

    @Override
    protected void doExecute() throws Exception {
        JavaMainCaller jcmd = super.getScalaCommand(false, this.mainConsole);
        VersionNumber scalaVersion = super.findScalaContext().version();
        Set<File> classpath = this.setupClassPathForConsole(scalaVersion);
        if (this.fork) {
            super.getLog().info((CharSequence)"Ignoring fork for console execution.");
        }
        String classpathStr = FileUtils.toMultiPath(classpath);
        jcmd.addArgs(this.args);
        jcmd.addOption("-cp", classpathStr);
        super.addCompilerPluginOptions(jcmd);
        this.handleJavaRebel(jcmd);
        jcmd.run(this.displayCmd);
    }

    private void handleJavaRebel(JavaMainCaller jcmd) throws IOException {
        if (this.javaRebelPath != null) {
            String canonicalJavaRebelPath = this.javaRebelPath.getCanonicalPath();
            if (this.javaRebelPath.exists()) {
                jcmd.addJvmArgs("-noverify", String.format("-javaagent:%s", canonicalJavaRebelPath));
            } else {
                super.getLog().warn((CharSequence)String.format("javaRevelPath '%s' not found", canonicalJavaRebelPath));
            }
        }
    }

    private Set<File> setupClassPathForConsole(VersionNumber scalaVersion) throws Exception {
        TreeSet<File> classpath = new TreeSet<File>();
        classpath.addAll(this.setupProjectClasspaths());
        classpath.addAll(this.setupConsoleClasspaths(scalaVersion));
        return classpath;
    }

    private Set<File> setupProjectClasspaths() throws Exception {
        TreeSet<File> classpath = new TreeSet<File>();
        super.addCompilerToClasspath(classpath);
        super.addLibraryToClasspath(classpath);
        if (this.useTestClasspath) {
            for (String s : this.project.getTestClasspathElements()) {
                classpath.add(new File(s));
            }
        }
        if (this.useRuntimeClasspath) {
            for (String s : this.project.getRuntimeClasspathElements()) {
                classpath.add(new File(s));
            }
        }
        return classpath;
    }

    private Set<File> setupConsoleClasspaths(VersionNumber scalaVersion) throws Exception {
        TreeSet<File> classpath = new TreeSet<File>();
        Artifact a = this.resolveJLine(this.fallbackJLine(scalaVersion));
        this.addToClasspath(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier(), classpath, true);
        return classpath;
    }

    private Artifact resolveJLine(Artifact defaultFallback) throws Exception {
        Set<Artifact> compilerDeps = super.findScalaContext().findCompilerAndDependencies();
        for (Artifact a : compilerDeps) {
            if (!this.filterForJline(a)) continue;
            return a;
        }
        super.getLog().warn((CharSequence)"Unable to determine the required Jline dependency from the POM. Falling back to hard-coded defaults.");
        super.getLog().warn((CharSequence)"If you get an InvocationTargetException, then this probably means we guessed the wrong version for JLine");
        super.getLog().warn((CharSequence)String.format("Guessed JLine: %s", defaultFallback.toString()));
        return defaultFallback;
    }

    private boolean filterForJline(Artifact artifact) {
        String artifactId = artifact.getArtifactId();
        String groupId = artifact.getGroupId();
        return artifactId.equals(JLINE) && groupId.equals(JLINE);
    }

    private Artifact fallbackJLine(VersionNumber scalaVersion) {
        VersionNumber scala2_12_0M4 = new VersionNumber("2.12.0-M4");
        VersionNumber scala2_11_0 = new VersionNumber("2.11.0");
        VersionNumber scala2_9_0 = new VersionNumber("2.9.0");
        if (scalaVersion.major == 3) {
            return this.factory.createArtifact("org.jline", JLINE, "3.19.0", "", "jar");
        }
        if (scala2_12_0M4.compareTo(scalaVersion) <= 0) {
            return this.factory.createArtifact(JLINE, JLINE, "2.14.1", "", "jar");
        }
        if (scala2_11_0.compareTo(scalaVersion) <= 0) {
            return this.factory.createArtifact(JLINE, JLINE, "2.12", "", "jar");
        }
        if (scala2_9_0.compareTo(scalaVersion) <= 0) {
            return this.factory.createArtifact(SCALA_ORG_GROUP, JLINE, scalaVersion.toString(), "", "jar");
        }
        return this.factory.createArtifact(JLINE, JLINE, "0.9.94", "", "jar");
    }
}

