/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.http.servlet;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.adamcin.httpsig.api.Authorization;
import net.adamcin.httpsig.api.Challenge;
import net.adamcin.httpsig.api.RequestContent;

public final class ServletUtil {
    private ServletUtil() {
    }

    public static Authorization getAuthorization(HttpServletRequest request) {
        Enumeration headerValues = request.getHeaders("Authorization");
        while (headerValues.hasMoreElements()) {
            String headerValue = (String)headerValues.nextElement();
            Authorization authorization = Authorization.parse((String)headerValue);
            if (authorization == null) continue;
            return authorization;
        }
        return null;
    }

    public static RequestContent getRequestContent(HttpServletRequest request) {
        return ServletUtil.getRequestContent(request, null);
    }

    public static RequestContent getRequestContent(HttpServletRequest request, Collection<String> ignoreHeaders) {
        HashSet<String> _ignore = new HashSet<String>();
        if (ignoreHeaders != null) {
            for (String ignore : ignoreHeaders) {
                _ignore.add(ignore.toLowerCase());
            }
        }
        RequestContent.Builder signatureContent = new RequestContent.Builder();
        String path = request.getRequestURI() + (request.getQueryString() != null ? "?" + request.getQueryString() : "");
        signatureContent.setRequestTarget(request.getMethod(), path);
        signatureContent.setRequestLine(request.getMethod() + " " + path + " " + request.getProtocol());
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (_ignore.contains(headerName.toLowerCase())) continue;
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                signatureContent.addHeader(headerName, headerValue);
            }
        }
        return signatureContent.build();
    }

    public static boolean sendChallenge(HttpServletResponse resp, Challenge challenge) throws IOException {
        if (!resp.isCommitted()) {
            resp.resetBuffer();
            resp.setStatus(401);
            resp.setHeader("WWW-Authenticate", challenge.getHeaderValue());
            resp.flushBuffer();
            return true;
        }
        return false;
    }
}

