/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.http.ning;

import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.ResponseFilter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.adamcin.httpsig.api.Authorization;
import net.adamcin.httpsig.api.Challenge;
import net.adamcin.httpsig.api.Signer;
import net.adamcin.httpsig.http.ning.AsyncUtil;

public class RotateAndReplayResponseFilter
implements ResponseFilter {
    private final Signer signer;

    public RotateAndReplayResponseFilter(Signer signer) {
        this.signer = signer;
    }

    public FilterContext filter(FilterContext ctx) throws FilterException {
        if (ctx.getResponseStatus().getStatusCode() == 401) {
            String header;
            Challenge challenge = null;
            Iterator iterator = ctx.getResponseHeaders().getHeaders().get((Object)"WWW-Authenticate").iterator();
            while (iterator.hasNext() && (challenge = Challenge.parse((String)(header = (String)iterator.next()))) == null) {
            }
            if (challenge != null) {
                Authorization authorization = null;
                Request request = ctx.getRequest();
                for (Map.Entry headersEntry : request.getHeaders()) {
                    String header2;
                    if (!((String)headersEntry.getKey()).equalsIgnoreCase("Authorization")) continue;
                    Iterator iterator2 = ((List)headersEntry.getValue()).iterator();
                    while (iterator2.hasNext() && (authorization = Authorization.parse((String)(header2 = (String)iterator2.next()))) == null) {
                    }
                }
                boolean replay = this.signer.rotateKeys(challenge, authorization);
                if (!replay) {
                    this.signer.rotateKeys(challenge);
                    return ctx;
                }
                RequestBuilder builder = new RequestBuilder(request);
                AsyncUtil.calculateSignature(this.signer, request, builder);
                return new FilterContext.FilterContextBuilder(ctx).replayRequest(replay).request(builder.build()).build();
            }
        }
        return ctx;
    }
}

