/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.http.ning;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilderBase;
import com.ning.http.client.Response;
import com.ning.http.client.SignatureCalculator;
import com.ning.http.client.filter.ResponseFilter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import net.adamcin.httpsig.api.Authorization;
import net.adamcin.httpsig.api.RequestContent;
import net.adamcin.httpsig.api.Signer;
import net.adamcin.httpsig.http.ning.AsyncSignatureCalculator;
import net.adamcin.httpsig.http.ning.RotateAndReplayResponseFilter;

public final class AsyncUtil {
    public static void enableAuth(AsyncHttpClient client, Signer signer) {
        AsyncUtil.enableAuth(client, signer, null);
    }

    public static void enableAuth(AsyncHttpClient client, Signer signer, SignatureCalculator calcBefore) {
        client.setSignatureCalculator((SignatureCalculator)new AsyncSignatureCalculator(signer, calcBefore));
    }

    public static Future<Response> login(AsyncHttpClient client, Signer signer, Request loginRequest) throws IOException {
        return AsyncUtil.login(client, signer, loginRequest, new AsyncCompletionHandler<Response>(){

            public Response onCompleted(Response response) throws Exception {
                return response;
            }
        });
    }

    public static <T> Future<T> login(AsyncHttpClient client, Signer signer, Request loginRequest, AsyncCompletionHandler<T> responseHandler) throws IOException {
        return AsyncUtil.login(client, signer, loginRequest, responseHandler, null);
    }

    public static <T> Future<T> login(AsyncHttpClient client, Signer signer, Request loginRequest, AsyncCompletionHandler<T> responseHandler, SignatureCalculator calcBefore) throws IOException {
        AsyncHttpClientConfig.Builder configBuilder = new AsyncHttpClientConfig.Builder(client.getConfig());
        configBuilder.addResponseFilter((ResponseFilter)new RotateAndReplayResponseFilter(signer));
        AsyncHttpClient loginClient = new AsyncHttpClient(configBuilder.build());
        AsyncUtil.enableAuth(loginClient, signer, calcBefore);
        ListenableFuture response = loginClient.executeRequest(loginClient.prepareRequest(loginRequest).setUrl(loginRequest.getUrl()).build(), responseHandler);
        AsyncUtil.enableAuth(client, signer, calcBefore);
        return response;
    }

    protected static String getRequestPath(Request request) {
        try {
            URL url = new URL(request.getUrl());
            return url.getPath() + (url.getQuery() != null ? "?" + url.getQuery() : "");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static void calculateSignature(Signer signer, Request request, RequestBuilderBase<?> requestBuilder) {
        Authorization authz;
        RequestContent.Builder sigBuilder = new RequestContent.Builder();
        sigBuilder.setRequestTarget(request.getMethod(), AsyncUtil.getRequestPath(request));
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                sigBuilder.addHeader((String)entry.getKey(), value);
            }
        }
        if (sigBuilder.build().getDate() == null) {
            sigBuilder.addDateNow();
            requestBuilder.addHeader("date", sigBuilder.build().getDate());
        }
        if ((authz = signer.sign(sigBuilder.build())) != null) {
            requestBuilder.setHeader("Authorization", authz.getHeaderValue());
        }
    }

    private AsyncUtil() {
    }
}

